/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHIssue
extends GHObject {
    GitHub root;
    GHRepository owner;
    protected GHUser assignee;
    protected String state;
    protected int number;
    protected String closed_at;
    protected int comments;
    protected String body;
    protected List<Label> labels;
    protected GHUser user;
    protected String title;
    protected String html_url;
    protected PullRequest pull_request;
    protected GHMilestone milestone;
    protected GHUser closed_by;

    GHIssue wrap(GHRepository owner) {
        this.owner = owner;
        if (this.milestone != null) {
            this.milestone.wrap(owner);
        }
        return this.wrap(owner.root);
    }

    GHIssue wrap(GitHub root) {
        this.root = root;
        if (this.assignee != null) {
            this.assignee.wrapUp(root);
        }
        if (this.user != null) {
            this.user.wrapUp(root);
        }
        if (this.closed_by != null) {
            this.closed_by.wrapUp(root);
        }
        return this;
    }

    static GHIssue[] wrap(GHIssue[] issues, GHRepository owner) {
        for (GHIssue i : issues) {
            i.wrap(owner);
        }
        return issues;
    }

    public GHRepository getRepository() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getTitle() {
        return this.title;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public Collection<GHLabel> getLabels() throws IOException {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.labels);
    }

    public Date getClosedAt() {
        return GitHub.parseDate(this.closed_at);
    }

    public URL getApiURL() {
        return GitHub.parseURL(this.url);
    }

    @WithBridgeMethods(value={void.class})
    public GHIssueComment comment(String message) throws IOException {
        GHIssueComment r = (GHIssueComment)((Object)new Requester(this.root).with("body", message).to(this.getIssuesApiRoute() + "/comments", GHIssueComment.class));
        return r.wrapUp(this);
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    private void editIssue(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getIssuesApiRoute());
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void assignTo(GHUser user) throws IOException {
        this.editIssue("assignee", user.getLogin());
    }

    public void setLabels(String ... labels) throws IOException {
        this.editIssue("labels", labels);
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.listComments().asList();
    }

    public PagedIterable<GHIssueComment> listComments() throws IOException {
        return new PagedIterable<GHIssueComment>(){

            @Override
            public PagedIterator<GHIssueComment> iterator() {
                return new PagedIterator<GHIssueComment>(GHIssue.this.root.retrieve().asIterator(GHIssue.this.getIssuesApiRoute() + "/comments", GHIssueComment[].class)){

                    protected void wrapUp(GHIssueComment[] page) {
                        for (GHIssueComment c : page) {
                            c.wrapUp(GHIssue.this);
                        }
                    }
                };
            }
        };
    }

    protected String getApiRoute() {
        return this.getIssuesApiRoute();
    }

    protected String getIssuesApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/issues/" + this.number;
    }

    public GHUser getAssignee() {
        return this.assignee;
    }

    public GHUser getUser() {
        return this.user;
    }

    public GHUser getClosedBy() {
        if (!"closed".equals(this.state)) {
            return null;
        }
        if (this.closed_by != null) {
            return this.closed_by;
        }
        return this.closed_by;
    }

    public int getCommentsCount() {
        return this.comments;
    }

    public PullRequest getPullRequest() {
        return this.pull_request;
    }

    public boolean isPullRequest() {
        return this.pull_request != null;
    }

    public GHMilestone getMilestone() {
        return this.milestone;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest {
        private String diff_url;
        private String patch_url;
        private String html_url;

        public URL getDiffUrl() {
            return GitHub.parseURL(this.diff_url);
        }

        public URL getPatchUrl() {
            return GitHub.parseURL(this.patch_url);
        }

        public URL getUrl() {
            return GitHub.parseURL(this.html_url);
        }
    }

    public static class Label
    extends GHLabel {
    }
}

