/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHOrgHook;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepoHook;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

class GHHooks {
    GHHooks() {
    }

    static Context repoContext(GHRepository repository, GHUser owner) {
        return new RepoContext(repository, owner);
    }

    static Context orgContext(GHOrganization organization) {
        return new OrgContext(organization);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrgContext
    extends Context {
        private final GHOrganization organization;

        private OrgContext(GHOrganization organization) {
            super(organization.root);
            this.organization = organization;
        }

        @Override
        String collection() {
            return String.format("/orgs/%s/hooks", this.organization.getLogin());
        }

        @Override
        Class<? extends GHHook[]> collectionClass() {
            return GHOrgHook[].class;
        }

        @Override
        Class<? extends GHHook> clazz() {
            return GHOrgHook.class;
        }

        @Override
        GHHook wrap(GHHook hook) {
            return ((GHOrgHook)hook).wrap(this.organization);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepoContext
    extends Context {
        private final GHRepository repository;
        private final GHUser owner;

        private RepoContext(GHRepository repository, GHUser owner) {
            super(repository.root);
            this.repository = repository;
            this.owner = owner;
        }

        @Override
        String collection() {
            return String.format("/repos/%s/%s/hooks", this.owner.getLogin(), this.repository.getName());
        }

        @Override
        Class<? extends GHHook[]> collectionClass() {
            return GHRepoHook[].class;
        }

        @Override
        Class<? extends GHHook> clazz() {
            return GHRepoHook.class;
        }

        @Override
        GHHook wrap(GHHook hook) {
            return ((GHRepoHook)hook).wrap(this.repository);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Context {
        private final GitHub root;

        private Context(GitHub root) {
            this.root = root;
        }

        public List<GHHook> getHooks() throws IOException {
            GHHook[] hookArray = (GHHook[])this.root.retrieve().to(this.collection(), this.collectionClass());
            ArrayList<GHHook> list = new ArrayList<GHHook>(Arrays.asList(hookArray));
            for (GHHook h : list) {
                this.wrap(h);
            }
            return list;
        }

        public GHHook getHook(int id) throws IOException {
            GHHook hook = (GHHook)((Object)this.root.retrieve().to(this.collection() + "/" + id, this.clazz()));
            return this.wrap(hook);
        }

        public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
            ArrayList<String> ea = null;
            if (events != null) {
                ea = new ArrayList<String>();
                for (GHEvent e : events) {
                    ea.add(e.name().toLowerCase(Locale.ENGLISH));
                }
            }
            GHHook hook = (GHHook)((Object)new Requester(this.root).with("name", name).with("active", active)._with("config", config)._with("events", ea).to(this.collection(), this.clazz()));
            return this.wrap(hook);
        }

        abstract String collection();

        abstract Class<? extends GHHook[]> collectionClass();

        abstract Class<? extends GHHook> clazz();

        abstract GHHook wrap(GHHook var1);
    }
}

