/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.cukes;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.runtime.java.StepDefAnnotation;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jvnet.hudson.annotation_indexer.AnnotationProcessorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class CukeAnnotationIndexer
extends AnnotationProcessorImpl {
    private Set<TypeElement> stepDefTypes = new HashSet<TypeElement>();
    private static final String STEP_DEF_ANNOTATION = StepDefAnnotation.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        super.execute(annotations, roundEnv);
        try {
            LinkedHashSet<String> contents = new LinkedHashSet<String>();
            try {
                FileObject in = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/cucumber-annotations");
                BufferedReader r = new BufferedReader(new InputStreamReader(in.openInputStream(), "UTF-8"));
                try {
                    String line;
                    while ((line = r.readLine()) != null) {
                        contents.add(line);
                    }
                }
                finally {
                    r.close();
                }
            }
            catch (FileNotFoundException x) {
                // empty catch block
            }
            FileObject out = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/cucumber-annotations", this.stepDefTypes.toArray(new Element[this.stepDefTypes.size()]));
            PrintWriter w = new PrintWriter(new OutputStreamWriter(out.openOutputStream(), "UTF-8"));
            try {
                for (TypeElement ann : this.stepDefTypes) {
                    contents.add(ann.getQualifiedName().toString());
                }
                for (String content : contents) {
                    w.println(content);
                }
            }
            finally {
                w.close();
            }
        }
        catch (IOException x) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
        }
    }

    protected boolean isIndexing(TypeElement ann) {
        boolean b;
        if (ann.getQualifiedName().contentEquals(Before.class.getName()) || ann.getQualifiedName().contentEquals(After.class.getName())) {
            return true;
        }
        boolean bl = b = this.findAnnotationOn(ann, STEP_DEF_ANNOTATION) != null;
        if (b) {
            this.stepDefTypes.add(ann);
        }
        return b;
    }
}

