/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin.service;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.ws.rs.HeaderParam;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class KucoinDigest
extends BaseParamsDigest {
    private String signature = "";

    private KucoinDigest(byte[] secretKey) {
        super(secretKey, "HmacSHA256");
    }

    public static KucoinDigest createInstance(String secretKey) {
        return Strings.isNullOrEmpty((String)secretKey) ? null : new KucoinDigest(secretKey.getBytes(StandardCharsets.UTF_8));
    }

    public String digestParams(RestInvocation restInvocation) {
        String pathWithQueryString = restInvocation.getInvocationUrl().replace(restInvocation.getBaseUrl(), "");
        String message = restInvocation.getParamValue(HeaderParam.class, "KC-API-TIMESTAMP").toString() + restInvocation.getHttpMethod() + pathWithQueryString + (restInvocation.getRequestBody() != null ? restInvocation.getRequestBody() : "");
        Mac mac256 = this.getMac();
        try {
            mac256.update(message.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new ExchangeException("Digest encoding exception", (Throwable)e);
        }
        this.signature = Base64.getEncoder().encodeToString(mac256.doFinal());
        return this.signature;
    }

    public String getSignature() {
        return this.signature;
    }
}

