/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.KlineIntervalType;
import org.knowm.xchange.kucoin.dto.response.AllTickersResponse;
import org.knowm.xchange.kucoin.dto.response.CurrenciesResponse;
import org.knowm.xchange.kucoin.dto.response.KucoinKline;
import org.knowm.xchange.kucoin.dto.response.KucoinResponse;
import org.knowm.xchange.kucoin.dto.response.OrderBookResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolTickResponse;
import org.knowm.xchange.kucoin.dto.response.TickerResponse;
import org.knowm.xchange.kucoin.dto.response.TradeFeeResponse;
import org.knowm.xchange.kucoin.dto.response.TradeHistoryResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinMarketDataServiceRaw
extends KucoinBaseService {
    protected KucoinMarketDataServiceRaw(KucoinExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public TickerResponse getKucoinTicker(CurrencyPair pair) throws IOException {
        return (TickerResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.symbolApi.getTicker(KucoinAdapters.adaptCurrencyPair(pair))).withRetry(this.retry("ticker")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public AllTickersResponse getKucoinTickers() throws IOException {
        return (AllTickersResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(this.symbolApi::getTickers).withRetry(this.retry("tickers")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public SymbolTickResponse getKucoin24hrStats(CurrencyPair pair) throws IOException {
        return (SymbolTickResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.symbolApi.getMarketStats(KucoinAdapters.adaptCurrencyPair(pair))).withRetry(this.retry("24hrStats")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public Map<String, BigDecimal> getKucoinPrices() throws IOException {
        return (Map)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(this.symbolApi::getPrices).withRetry(this.retry("prices")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public TradeFeeResponse getKucoinBaseFee() throws IOException {
        this.checkAuthenticated();
        return (TradeFeeResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.tradingFeeAPI.getBaseFee(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase)).withRetry(this.retry("baseFee")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public List<TradeFeeResponse> getKucoinTradeFee(String symbols) throws IOException {
        this.checkAuthenticated();
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.tradingFeeAPI.getTradeFee(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, symbols)).withRetry(this.retry("tradeFee")).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public List<SymbolResponse> getKucoinSymbols() throws IOException {
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(this.symbolApi::getSymbols).withRetry(this.retry("symbols")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public List<CurrenciesResponse> getKucoinCurrencies() throws IOException {
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(this.symbolApi::getCurrencies).withRetry(this.retry("currencies")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public OrderBookResponse getKucoinOrderBookPartial(CurrencyPair pair) throws IOException {
        return (OrderBookResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.orderBookApi.getPartOrderBookAggregated(KucoinAdapters.adaptCurrencyPair(pair))).withRetry(this.retry("partialOrderBook")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public OrderBookResponse getKucoinOrderBookPartialShallow(CurrencyPair pair) throws IOException {
        return (OrderBookResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.orderBookApi.getPartOrderBookShallowAggregated(KucoinAdapters.adaptCurrencyPair(pair))).withRetry(this.retry("partialShallowOrderBook")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public OrderBookResponse getKucoinOrderBookFull(CurrencyPair pair) throws IOException {
        return (OrderBookResponse)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.orderBookApi.getFullOrderBookAggregated(KucoinAdapters.adaptCurrencyPair(pair), this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase)).withRetry(this.retry("fullOrderBook")).withRateLimiter(this.rateLimiter("privateEndpointLimit")).call());
    }

    public List<TradeHistoryResponse> getKucoinTrades(CurrencyPair pair) throws IOException {
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.historyApi.getTradeHistories(KucoinAdapters.adaptCurrencyPair(pair))).withRetry(this.retry("tradeHistories")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
    }

    public List<KucoinKline> getKucoinKlines(CurrencyPair pair, Long startTime, Long endTime, KlineIntervalType type) throws IOException {
        List raw = (List)KucoinExceptionClassifier.classifyingExceptions(() -> (KucoinResponse)this.decorateApiCall(() -> this.historyApi.getKlines(KucoinAdapters.adaptCurrencyPair(pair), startTime, endTime, type.code())).withRetry(this.retry("klines")).withRateLimiter(this.rateLimiter("publicEndpointLimit")).call());
        return raw.stream().map(obj -> new KucoinKline(pair, type, (Object[])obj)).collect(Collectors.toList());
    }
}

