/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.kucoin.KucoinAccountService;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinMarketDataService;
import org.knowm.xchange.kucoin.KucoinResilience;
import org.knowm.xchange.kucoin.KucoinTradeService;
import org.knowm.xchange.kucoin.dto.response.CurrenciesResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolResponse;
import org.knowm.xchange.kucoin.dto.response.TradeFeeResponse;
import org.knowm.xchange.kucoin.dto.response.WebsocketResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinExchange
extends BaseExchange
implements Exchange {
    public static final String PARAM_SANDBOX = "Use_Sandbox";
    static final String SANDBOX_URI = "https://openapi-sandbox.kucoin.com";
    static final String PROD_URI = "https://api.kucoin.com";
    private static ResilienceRegistries RESILIENCE_REGISTRIES;

    private void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null) {
            if (Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem(PARAM_SANDBOX))) {
                this.logger.debug("Connecting to sandbox");
                exchangeSpecification.setSslUri(SANDBOX_URI);
                try {
                    URL url = new URL(SANDBOX_URI);
                    exchangeSpecification.setHost(url.getHost());
                }
                catch (MalformedURLException exception) {
                    this.logger.error("Kucoin sandbox host exception: {}", (Object)exception.getMessage());
                }
            } else {
                this.logger.debug("Connecting to live");
            }
        }
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        this.concludeHostParams(exchangeSpecification);
    }

    protected void initServices() {
        this.concludeHostParams(this.exchangeSpecification);
        this.marketDataService = new KucoinMarketDataService(this, this.getResilienceRegistries());
        this.accountService = new KucoinAccountService(this, this.getResilienceRegistries());
        this.tradeService = new KucoinTradeService(this, this.getResilienceRegistries());
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri(PROD_URI);
        try {
            URL url = new URL(PROD_URI);
            exchangeSpecification.setHost(url.getHost());
        }
        catch (MalformedURLException exception) {
            this.logger.error("Kucoin host exception: {}", (Object)exception.getMessage());
        }
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Kucoin");
        exchangeSpecification.setExchangeDescription("Kucoin is a bitcoin and altcoin exchange.");
        return exchangeSpecification;
    }

    public ResilienceRegistries getResilienceRegistries() {
        if (RESILIENCE_REGISTRIES == null) {
            RESILIENCE_REGISTRIES = KucoinResilience.createRegistries();
        }
        return RESILIENCE_REGISTRIES;
    }

    public void remoteInit() throws IOException, ExchangeException {
        TradeFeeResponse fee = null;
        if (this.exchangeSpecification.getApiKey() != null) {
            fee = this.getMarketDataService().getKucoinBaseFee();
        }
        List<CurrenciesResponse> currenciesResponses = this.getMarketDataService().getKucoinCurrencies();
        List<SymbolResponse> symbolsResponse = this.getMarketDataService().getKucoinSymbols();
        this.exchangeMetaData = KucoinAdapters.adaptMetadata(this.exchangeMetaData, currenciesResponses, symbolsResponse, fee);
    }

    public KucoinMarketDataService getMarketDataService() {
        return (KucoinMarketDataService)super.getMarketDataService();
    }

    public KucoinTradeService getTradeService() {
        return (KucoinTradeService)super.getTradeService();
    }

    public KucoinAccountService getAccountService() {
        return (KucoinAccountService)super.getAccountService();
    }

    public WebsocketResponse getPublicWebsocketConnectionDetails() throws IOException {
        return (WebsocketResponse)KucoinExceptionClassifier.classifyingExceptions(this.getAccountService().websocketAPI::getPublicWebsocketDetails);
    }

    public WebsocketResponse getPrivateWebsocketConnectionDetails() throws IOException {
        this.getAccountService().checkAuthenticated();
        return (WebsocketResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.getAccountService().websocketAPI.getPrivateWebsocketDetails(this.getAccountService().apiKey, (ParamsDigest)this.getAccountService().digest, (SynchronizedValueFactory<Long>)this.getAccountService().nonceFactory, this.getAccountService().passphrase));
    }
}

