/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.ExchangeSecurityException;
import org.knowm.xchange.exceptions.ExchangeUnavailableException;
import org.knowm.xchange.exceptions.NonceException;
import org.knowm.xchange.kucoin.dto.response.KucoinResponse;
import org.knowm.xchange.kucoin.service.KucoinApiException;

public final class KucoinExceptionClassifier {
    KucoinExceptionClassifier() {
    }

    public static <T> T classifyingExceptions(IOExceptionThrowingSupplier<KucoinResponse<T>> apiCall) throws IOException {
        KucoinResponse<T> response = apiCall.get();
        if (response.isSuccessful()) {
            return response.getData();
        }
        throw KucoinExceptionClassifier.classify(new KucoinApiException(response.getCode(), response.getMessage()));
    }

    public static RuntimeException classify(KucoinApiException e) {
        if (e.getMessage().equalsIgnoreCase("Service unavailable")) {
            return new ExchangeUnavailableException(e.getMessage(), (Throwable)e);
        }
        if (e.getMessage().contains("check environment variables")) {
            return new ExchangeSecurityException(e.getMessage(), (Throwable)e);
        }
        switch (e.getCode()) {
            case "400001": 
            case "400003": 
            case "400004": 
            case "400006": 
            case "400007": 
            case "411100": {
                return new ExchangeSecurityException(e.getMessage(), (Throwable)e);
            }
            case "400005": {
                return new NonceException(e.getMessage(), (Throwable)e);
            }
        }
        return new ExchangeException(e.getMessage(), (Throwable)e);
    }

    @FunctionalInterface
    static interface IOExceptionThrowingSupplier<T> {
        public T get() throws IOException;
    }
}

