/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.ItBitException;
import org.knowm.xchange.itbit.dto.trade.ItBitOrder;
import org.knowm.xchange.itbit.dto.trade.ItBitOrderFlags;
import org.knowm.xchange.itbit.dto.trade.ItBitPlaceOrderRequest;
import org.knowm.xchange.itbit.dto.trade.ItBitTradeHistory;
import org.knowm.xchange.itbit.service.ItBitBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class ItBitTradeServiceRaw
extends ItBitBaseService {
    public ItBitTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public ItBitOrder[] getItBitOpenOrders(CurrencyPair currencyPair) throws IOException {
        CurrencyPair exchangePair = ItBitAdapters.adaptCurrencyPairToExchange(currencyPair);
        ItBitOrder[] orders = this.itBitAuthenticated.getOrders(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), exchangePair.base.getCurrencyCode() + exchangePair.counter.getCurrencyCode(), "1", "1000", "open", this.walletId);
        return orders;
    }

    public ItBitOrder[] getItBitOrders(String status, String instrument) throws IOException {
        ItBitOrder[] orders = this.itBitAuthenticated.getOrders(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), instrument, "1", "1000", status, this.walletId);
        return orders;
    }

    public ItBitOrder getItBitOrder(String orderId) throws IOException {
        ItBitOrder order = this.itBitAuthenticated.getOrder(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, orderId);
        return order;
    }

    public ItBitOrder placeItBitLimitOrder(LimitOrder limitOrder) throws IOException {
        String side = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "buy" : "sell";
        CurrencyPair exchangePair = ItBitAdapters.adaptCurrencyPairToExchange(limitOrder.getCurrencyPair());
        String amount = ItBitAdapters.formatCryptoAmount(limitOrder.getOriginalAmount());
        String price = ItBitAdapters.formatFiatAmount(limitOrder.getLimitPrice());
        ItBitOrder postOrder = this.itBitAuthenticated.postOrder(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, new ItBitPlaceOrderRequest(side, "limit", exchangePair.base.getCurrencyCode(), amount, price, exchangePair.base.getCurrencyCode() + exchangePair.counter.getCurrencyCode(), limitOrder.getOrderFlags().contains((Object)ItBitOrderFlags.POST_ONLY)));
        return postOrder;
    }

    public void cancelItBitOrder(String orderId) throws IOException {
        this.itBitAuthenticated.cancelOrder(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, orderId);
    }

    public ItBitOrder[] getItBitOrderHistory(String currency, String pageNum, String pageLen) throws IOException {
        ItBitOrder[] orders = this.itBitAuthenticated.getOrders(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency, pageNum, pageLen, "filled", this.walletId);
        return orders;
    }

    public ItBitTradeHistory getUserTradeHistory(String lastExecutionId, Integer page, Integer perPage, Date rangeStart, Date rangeEnd) throws IOException, ItBitException {
        return this.itBitAuthenticated.getUserTradeHistory(this.signatureCreator, System.currentTimeMillis(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, lastExecutionId, page, perPage, rangeStart, rangeEnd);
    }
}

