/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.marketdata.ItBitDepth;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTicker;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTrades;
import org.knowm.xchange.itbit.service.ItBitBaseService;

public class ItBitMarketDataServiceRaw
extends ItBitBaseService {
    public ItBitMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public ItBitTicker getItBitTicker(CurrencyPair currencyPair) throws IOException {
        CurrencyPair exchangePair = ItBitAdapters.adaptCurrencyPairToExchange(currencyPair);
        ItBitTicker ticker = this.itBitAuthenticated.getTicker(exchangePair.base.getCurrencyCode(), exchangePair.counter.getCurrencyCode());
        return ticker;
    }

    public ItBitDepth getItBitDepth(CurrencyPair currencyPair, Object ... args) throws IOException {
        CurrencyPair exchangePair = ItBitAdapters.adaptCurrencyPairToExchange(currencyPair);
        ItBitDepth depth = this.itBitPublic.getDepth(exchangePair.base.getCurrencyCode(), exchangePair.counter.getCurrencyCode());
        return depth;
    }

    public ItBitTrades getItBitTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        long since = 0L;
        if (args.length == 1) {
            since = ((Number)args[0]).longValue();
        }
        CurrencyPair exchangePair = ItBitAdapters.adaptCurrencyPairToExchange(currencyPair);
        ItBitTrades trades = this.itBitPublic.getTrades(exchangePair.base.getCurrencyCode(), exchangePair.counter.getCurrencyCode(), since);
        return trades;
    }
}

