/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.ItBitFundingHistoryResponse;
import org.knowm.xchange.itbit.dto.account.ItBitAccountInfoReturn;
import org.knowm.xchange.itbit.dto.account.ItBitDepositRequest;
import org.knowm.xchange.itbit.dto.account.ItBitDepositResponse;
import org.knowm.xchange.itbit.dto.account.ItBitWithdrawalRequest;
import org.knowm.xchange.itbit.dto.account.ItBitWithdrawalResponse;
import org.knowm.xchange.itbit.service.ItBitBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class ItBitAccountServiceRaw
extends ItBitBaseService {
    public ItBitAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public ItBitAccountInfoReturn[] getItBitAccountInfo() throws IOException {
        ItBitAccountInfoReturn[] info = this.itBitAuthenticated.getInfo(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.userId);
        return info;
    }

    public List getAllWallets() {
        return this.itBitAuthenticated.wallets(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new Date().getTime(), this.userId, 1, 50);
    }

    public ItBitFundingHistoryResponse getFunding(int page, int perPage) {
        return this.itBitAuthenticated.fundingHistory(this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), new Date().getTime(), this.walletId, page, perPage);
    }

    public String withdrawItBitFunds(String currency, BigDecimal amount, String address) throws IOException {
        String formattedAmount = ItBitAdapters.formatCryptoAmount(amount);
        ItBitWithdrawalRequest request = new ItBitWithdrawalRequest(currency, formattedAmount, address);
        ItBitWithdrawalResponse response = this.itBitAuthenticated.requestWithdrawal(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, request);
        return response.getId();
    }

    public String requestItBitDepositAddress(String currency, String ... args) throws IOException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (int i = 0; i < args.length - 1; i += 2) {
            metadata.put(args[i], args[i + 1]);
        }
        ItBitDepositRequest request = new ItBitDepositRequest(currency, metadata);
        ItBitDepositResponse response = this.itBitAuthenticated.requestDeposit(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), this.walletId, request);
        return response.getDepositAddress();
    }

    public ItBitAccountInfoReturn getItBitAccountInfo(String walletId) throws IOException {
        ItBitAccountInfoReturn itBitAccountInfoReturn = this.itBitAuthenticated.getWallet(this.signatureCreator, new Date().getTime(), (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), walletId);
        return itBitAccountInfoReturn;
    }
}

