/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.ItBitFunding;
import org.knowm.xchange.itbit.dto.ItBitFundingHistoryResponse;
import org.knowm.xchange.itbit.service.ItBitAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class ItBitAccountService
extends ItBitAccountServiceRaw
implements AccountService {
    public ItBitAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return ItBitAdapters.adaptAccountInfo(this.getItBitAccountInfo());
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawItBitFunds(currency.toString(), amount, address);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.getCurrency(), defaultParams.getAmount(), defaultParams.getAddress());
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.requestItBitDepositAddress(currency.toString(), args);
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        int page = 1;
        int perPage = 50;
        if (params instanceof TradeHistoryParamPaging) {
            TradeHistoryParamPaging tradeHistoryParamPaging = (TradeHistoryParamPaging)params;
            perPage = tradeHistoryParamPaging.getPageLength();
            page = tradeHistoryParamPaging.getPageNumber();
        }
        ArrayList<FundingRecord> fundingRecords = new ArrayList<FundingRecord>();
        ItBitFundingHistoryResponse funding = this.getFunding(page, perPage);
        for (ItBitFunding itBitFunding : funding.fundingHistory) {
            FundingRecord fundingRecord = ItBitAdapters.adapt(itBitFunding);
            fundingRecords.add(fundingRecord);
        }
        return fundingRecords;
    }

    public static class ItBitFundingParams
    implements TradeHistoryParamPaging {
        private Integer pageLength = 50;
        private Integer pageNumber = 1;

        public Integer getPageLength() {
            return this.pageLength;
        }

        public void setPageLength(Integer pageLength) {
            this.pageLength = pageLength;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }
    }
}

