/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.itbit.ItBitAdapters;
import org.knowm.xchange.itbit.dto.marketdata.ItBitDepth;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTicker;
import org.knowm.xchange.itbit.service.ItBitMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class ItBitMarketDataService
extends ItBitMarketDataServiceRaw
implements MarketDataService {
    public ItBitMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        ItBitTicker itBitTicker = this.getItBitTicker(currencyPair);
        return ItBitAdapters.adaptTicker(currencyPair, itBitTicker);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        ItBitDepth depth = this.getItBitDepth(currencyPair, args);
        List<LimitOrder> asks = ItBitAdapters.adaptOrders(depth.getAsks(), currencyPair, Order.OrderType.ASK);
        List<LimitOrder> bids = ItBitAdapters.adaptOrders(depth.getBids(), currencyPair, Order.OrderType.BID);
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return ItBitAdapters.adaptTrades(this.getItBitTrades(currencyPair, args), currencyPair);
    }
}

