/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit.service;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import si.mazi.rescu.RestInvocation;

public class ItBitHmacPostBodyDigest
extends BaseParamsDigest {
    private static final String FIELD_SEPARATOR = "\",\"";
    private final String apiKey;
    private final Charset charset;

    private ItBitHmacPostBodyDigest(String apiKey, String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
        this.apiKey = apiKey;
        this.charset = Charset.forName("UTF-8");
    }

    public static ItBitHmacPostBodyDigest createInstance(String apiKey, String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new ItBitHmacPostBodyDigest(apiKey, secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Illegal algorithm for post body digest. Check the implementation.");
        }
        Map httpHeaders = restInvocation.getHttpHeadersFromParams();
        String currentNonce = (String)httpHeaders.get("X-Auth-Nonce");
        String currentTimestamp = (String)httpHeaders.get("X-Auth-Timestamp");
        String requestBody = restInvocation.getRequestBody();
        requestBody = requestBody == null ? "" : requestBody.replace("\"", "\\\"");
        String verb = restInvocation.getHttpMethod().trim();
        String invocationUrl = restInvocation.getInvocationUrl().trim();
        String jsonEncodedArray = "[\"" + verb + FIELD_SEPARATOR + invocationUrl + FIELD_SEPARATOR + requestBody + FIELD_SEPARATOR + currentNonce + FIELD_SEPARATOR + currentTimestamp + "\"]";
        md.update(currentNonce.getBytes(this.charset));
        md.update(jsonEncodedArray.getBytes(this.charset));
        byte[] messageHash = md.digest();
        Mac mac512 = this.getMac();
        mac512.update(invocationUrl.getBytes(this.charset));
        mac512.update(messageHash);
        byte[] hmacDigest = mac512.doFinal();
        return this.apiKey + ":" + Base64.getEncoder().encodeToString(hmacDigest);
    }
}

