/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ItBitDateDeserializer
extends JsonDeserializer<Date> {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public ItBitDateDeserializer() {
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getValueAsString().replaceFirst("0000Z$", "");
        try {
            return this.simpleDateFormat.parse(value);
        }
        catch (ParseException e) {
            throw new InvalidFormatException(jp, "Can't parse date at offset " + e.getErrorOffset(), (Object)value, Date.class);
        }
    }
}

