/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.itbit;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.itbit.dto.ItBitException;
import org.knowm.xchange.itbit.dto.ItBitFundingHistoryResponse;
import org.knowm.xchange.itbit.dto.account.ItBitAccountInfoReturn;
import org.knowm.xchange.itbit.dto.account.ItBitDepositRequest;
import org.knowm.xchange.itbit.dto.account.ItBitDepositResponse;
import org.knowm.xchange.itbit.dto.account.ItBitWithdrawalRequest;
import org.knowm.xchange.itbit.dto.account.ItBitWithdrawalResponse;
import org.knowm.xchange.itbit.dto.marketdata.ItBitTicker;
import org.knowm.xchange.itbit.dto.trade.ItBitOrder;
import org.knowm.xchange.itbit.dto.trade.ItBitPlaceOrderRequest;
import org.knowm.xchange.itbit.dto.trade.ItBitTradeHistory;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v1")
@Produces(value={"application/json"})
public interface ItBitAuthenticated {
    @GET
    @Path(value="/markets/{ident}{currency}/ticker")
    public ItBitTicker getTicker(@PathParam(value="ident") String var1, @PathParam(value="currency") String var2) throws IOException, ItBitException;

    @GET
    @Path(value="wallets")
    public ItBitAccountInfoReturn[] getInfo(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @QueryParam(value="userId") String var5) throws IOException, ItBitException;

    @GET
    @Path(value="wallets/{walletId}")
    public ItBitAccountInfoReturn getWallet(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5) throws IOException, ItBitException;

    @GET
    @Path(value="wallets/{walletId}/orders")
    public ItBitOrder[] getOrders(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @QueryParam(value="instrument") String var5, @QueryParam(value="page") String var6, @QueryParam(value="perPage") String var7, @QueryParam(value="status") String var8, @PathParam(value="walletId") String var9) throws IOException, ItBitException;

    @GET
    @Path(value="wallets/{walletId}/orders/{orderId}")
    public ItBitOrder getOrder(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, @PathParam(value="orderId") String var6) throws IOException, ItBitException;

    @POST
    @Path(value="wallets/{walletId}/orders")
    @Consumes(value={"application/json"})
    public ItBitOrder postOrder(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, ItBitPlaceOrderRequest var6) throws IOException, ItBitException;

    @DELETE
    @Path(value="wallets/{walletId}/orders/{orderId}")
    public Object cancelOrder(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, @PathParam(value="orderId") String var6) throws IOException, ItBitException;

    @POST
    @Path(value="wallets/{walletId}/cryptocurrency_withdrawals")
    @Consumes(value={"application/json"})
    public ItBitWithdrawalResponse requestWithdrawal(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, ItBitWithdrawalRequest var6) throws IOException, ItBitException;

    @POST
    @Path(value="wallets/{walletId}/cryptocurrency_deposits")
    @Consumes(value={"application/json"})
    public ItBitDepositResponse requestDeposit(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, ItBitDepositRequest var6) throws IOException, ItBitException;

    @GET
    @Path(value="wallets/{walletId}/trades")
    @Consumes(value={"application/json"})
    public ItBitTradeHistory getUserTradeHistory(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Timestamp") long var2, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var4, @PathParam(value="walletId") String var5, @QueryParam(value="lastExecutionId") String var6, @QueryParam(value="page") Integer var7, @QueryParam(value="perPage") Integer var8, @QueryParam(value="rangeStart") Date var9, @QueryParam(value="rangeEnd") Date var10) throws IOException, ItBitException;

    @GET
    @Path(value="wallets")
    @Consumes(value={"application/json"})
    public List wallets(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-Auth-Timestamp") long var3, @QueryParam(value="userId") String var5, @QueryParam(value="page") int var6, @QueryParam(value="perPage") int var7);

    @GET
    @Path(value="wallets/{walletId}/funding_history")
    @Consumes(value={"application/json"})
    public ItBitFundingHistoryResponse fundingHistory(@HeaderParam(value="Authorization") ParamsDigest var1, @HeaderParam(value="X-Auth-Nonce") SynchronizedValueFactory<Long> var2, @HeaderParam(value="X-Auth-Timestamp") long var3, @PathParam(value="walletId") String var5, @QueryParam(value="page") int var6, @QueryParam(value="perPage") int var7);
}

