/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.FeeTier;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcMetaData;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSymbol;
import org.knowm.xchange.hitbtc.v2.service.HitbtcAccountService;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataService;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataServiceRaw;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HitbtcExchange
extends BaseExchange
implements Exchange {
    private static final Logger LOGGER = LoggerFactory.getLogger(HitbtcExchange.class);
    private HitbtcMetaData hitbtcMetaData;

    private static void setupPatchSupport() {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            methodsField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"};
            methodsField.set(null, methods);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Error while setting up PATCH support");
        }
    }

    protected void initServices() {
        this.marketDataService = new HitbtcMarketDataService(this);
        this.tradeService = new HitbtcTradeService(this);
        this.accountService = new HitbtcAccountService(this);
    }

    protected void loadExchangeMetaData(InputStream is) {
        this.hitbtcMetaData = (HitbtcMetaData)((Object)this.loadMetaData(is, HitbtcMetaData.class));
        this.exchangeMetaData = HitbtcAdapters.adaptToExchangeMetaData(null, this.hitbtcMetaData.getCurrencies(), this.hitbtcMetaData.getCurrencyPairs());
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.hitbtc.com");
        exchangeSpecification.setHost("hitbtc.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Hitbtc");
        exchangeSpecification.setExchangeDescription("Hitbtc is a Bitcoin exchange.");
        exchangeSpecification.setExchangeSpecificParametersItem("demo-api", (Object)"http://demo-api.hitbtc.com");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException {
        HitbtcMarketDataServiceRaw dataService = (HitbtcMarketDataServiceRaw)this.marketDataService;
        List<HitbtcSymbol> hitbtcSymbols = dataService.getHitbtcSymbols();
        Map<Currency, CurrencyMetaData> currencies = dataService.getHitbtcCurrencies().stream().collect(Collectors.toMap(hitbtcCurrency -> new Currency(hitbtcCurrency.getId()), hitbtcCurrency -> new CurrencyMetaData(null, hitbtcCurrency.getPayoutFee())));
        Map<CurrencyPair, CurrencyPairMetaData> currencyPairs = hitbtcSymbols.stream().collect(Collectors.toMap(hitbtcSymbol -> new CurrencyPair(new Currency(hitbtcSymbol.getBaseCurrency()), new Currency(hitbtcSymbol.getQuoteCurrency())), hitbtcSymbol -> new CurrencyPairMetaData((BigDecimal)null, hitbtcSymbol.getQuantityIncrement(), (BigDecimal)null, Integer.valueOf(hitbtcSymbol.getTickSize().scale()), (FeeTier[])null)));
        this.exchangeMetaData = HitbtcAdapters.adaptToExchangeMetaData(hitbtcSymbols, currencies, currencyPairs);
    }

    static {
        HitbtcExchange.setupPatchSupport();
    }
}

