/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.LoanOrderBook;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.FixedRateLoanOrder;
import org.knowm.xchange.dto.trade.FloatingRateLoanOrder;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.gemini.v1.GeminiAdapters;
import org.knowm.xchange.gemini.v1.GeminiUtils;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiDepth;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiLendDepth;
import org.knowm.xchange.gemini.v1.dto.marketdata.GeminiTrade;
import org.knowm.xchange.gemini.v1.service.GeminiMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GeminiMarketDataService
extends GeminiMarketDataServiceRaw
implements MarketDataService {
    public GeminiMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return GeminiAdapters.adaptTicker(this.getGeminiTicker(GeminiUtils.toPairString(currencyPair)), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        Integer limitBids = null;
        Integer limitAsks = null;
        if (args != null && args.length == 2) {
            Object arg0 = args[0];
            if (!(arg0 instanceof Integer)) {
                throw new ExchangeException("Argument 0 must be an Integer!");
            }
            limitBids = (Integer)arg0;
            Object arg1 = args[1];
            if (!(arg1 instanceof Integer)) {
                throw new ExchangeException("Argument 1 must be an Integer!");
            }
            limitAsks = (Integer)arg1;
        }
        GeminiDepth GeminiDepth2 = this.getGeminiOrderBook(GeminiUtils.toPairString(currencyPair), limitBids, limitAsks);
        OrderBook orderBook = GeminiAdapters.adaptOrderBook(GeminiDepth2, currencyPair);
        return orderBook;
    }

    public LoanOrderBook getLendOrderBook(String currency, Object ... args) throws IOException {
        int limitBids = 50;
        int limitAsks = 50;
        if (args != null && args.length == 2) {
            Object arg0 = args[0];
            if (!(arg0 instanceof Integer)) {
                throw new ExchangeException("Argument 0 must be an Integer!");
            }
            limitBids = (Integer)arg0;
            Object arg1 = args[1];
            if (!(arg1 instanceof Integer)) {
                throw new ExchangeException("Argument 1 must be an Integer!");
            }
            limitAsks = (Integer)arg1;
        }
        GeminiLendDepth GeminiLendDepth2 = this.getGeminiLendBook(currency, limitBids, limitAsks);
        List<FixedRateLoanOrder> fixedRateAsks = GeminiAdapters.adaptFixedRateLoanOrders(GeminiLendDepth2.getAsks(), currency, "ask", "");
        List<FixedRateLoanOrder> fixedRateBids = GeminiAdapters.adaptFixedRateLoanOrders(GeminiLendDepth2.getBids(), currency, "bid", "");
        List<FloatingRateLoanOrder> floatingRateAsks = GeminiAdapters.adaptFloatingRateLoanOrders(GeminiLendDepth2.getAsks(), currency, "ask", "");
        List<FloatingRateLoanOrder> floatingRateBids = GeminiAdapters.adaptFloatingRateLoanOrders(GeminiLendDepth2.getBids(), currency, "bid", "");
        return new LoanOrderBook(null, fixedRateAsks, fixedRateBids, floatingRateAsks, floatingRateBids);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        int limitTrades = 50;
        if (args != null && args.length > 1) {
            if (args[1] instanceof Integer) {
                limitTrades = (Integer)args[1];
            } else {
                throw new ExchangeException("Argument 1 must be an Integer!");
            }
        }
        long lastTradeTime = 0L;
        if (args != null && args.length > 0) {
            Serializable arg;
            if (args[0] instanceof Number) {
                arg = (Number)args[0];
                lastTradeTime = ((Number)arg).longValue() / 1000L;
            } else if (args[0] instanceof Date) {
                arg = (Date)args[0];
                lastTradeTime = ((Date)arg).getTime() / 1000L;
            } else {
                throw new IllegalArgumentException("Argument 0, the last trade time, must be a Date or Long (millisecond timestamp) (was " + args[0].getClass() + ")");
            }
        }
        GeminiTrade[] trades = this.getGeminiTrades(GeminiUtils.toPairString(currencyPair), lastTradeTime, limitTrades);
        return GeminiAdapters.adaptTrades(trades, currencyPair);
    }
}

