/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.gemini.v1.GeminiUtils;
import org.knowm.xchange.gemini.v1.dto.GeminiException;
import org.knowm.xchange.gemini.v1.dto.account.GeminiBalancesRequest;
import org.knowm.xchange.gemini.v1.dto.account.GeminiBalancesResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiDepositAddressRequest;
import org.knowm.xchange.gemini.v1.dto.account.GeminiDepositAddressResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTrailingVolumeRequest;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTrailingVolumeResponse;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTransfer;
import org.knowm.xchange.gemini.v1.dto.account.GeminiTransfersRequest;
import org.knowm.xchange.gemini.v1.dto.account.GeminiWithdrawalRequest;
import org.knowm.xchange.gemini.v1.dto.account.GeminiWithdrawalResponse;
import org.knowm.xchange.gemini.v1.service.GeminiBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public class GeminiAccountServiceRaw
extends GeminiBaseService {
    protected final List<CurrencyPair> allCurrencyPairs;

    public GeminiAccountServiceRaw(Exchange exchange) {
        super(exchange);
        this.allCurrencyPairs = new ArrayList(exchange.getExchangeMetaData().getCurrencyPairs().keySet());
    }

    public List<GeminiTransfer> transfers(Date from, Integer limit) throws IOException {
        SynchronizedValueFactory nonceFactory = this.exchange.getNonceFactory();
        GeminiTransfersRequest geminiTransfersRequest = GeminiTransfersRequest.create(from, limit, (SynchronizedValueFactory<Long>)nonceFactory);
        return this.gemini.transfers(this.apiKey, this.payloadCreator, this.signatureCreator, geminiTransfersRequest);
    }

    public GeminiBalancesResponse[] getGeminiAccountInfo() throws IOException {
        try {
            GeminiBalancesRequest request = new GeminiBalancesRequest(String.valueOf(this.exchange.getNonceFactory().createValue()));
            GeminiBalancesResponse[] balances = this.gemini.balances(this.apiKey, this.payloadCreator, this.signatureCreator, request);
            return balances;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public String withdraw(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            String ccy = GeminiUtils.convertToGeminiCcyName(currency.getCurrencyCode());
            GeminiWithdrawalRequest request = new GeminiWithdrawalRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), ccy, amount, address);
            GeminiWithdrawalResponse withdrawRepsonse = this.gemini.withdraw(this.apiKey, this.payloadCreator, this.signatureCreator, ccy, request);
            return withdrawRepsonse.txHash;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiDepositAddressResponse requestDepositAddressRaw(Currency currency) throws IOException {
        try {
            String ccy = GeminiUtils.convertToGeminiCcyName(currency.getCurrencyCode());
            GeminiDepositAddressRequest exchange = new GeminiDepositAddressRequest(String.valueOf(this.exchange.getNonceFactory().createValue()), ccy, null);
            GeminiDepositAddressResponse requestDepositAddressResponse = this.gemini.requestNewAddress(this.apiKey, this.payloadCreator, this.signatureCreator, ccy, exchange);
            if (requestDepositAddressResponse != null) {
                return requestDepositAddressResponse;
            }
            return null;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }

    public GeminiTrailingVolumeResponse Get30DayTrailingVolumeDescription() throws IOException {
        try {
            GeminiTrailingVolumeRequest request = new GeminiTrailingVolumeRequest(String.valueOf(this.exchange.getNonceFactory().createValue()));
            GeminiTrailingVolumeResponse trailingVolResp = this.gemini.TrailingVolume(this.apiKey, this.payloadCreator, this.signatureCreator, request);
            return trailingVolResp;
        }
        catch (GeminiException e) {
            throw this.handleException(e);
        }
    }
}

