/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gemini.v1.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;

public class GeminiTicker {
    private final BigDecimal bid;
    private final BigDecimal ask;
    private final BigDecimal last;
    private final Volume volume;

    public GeminiTicker(@JsonProperty(value="bid") BigDecimal bid, @JsonProperty(value="ask") BigDecimal ask, @JsonProperty(value="last") BigDecimal last, @JsonProperty(value="volume") Map<String, Object> volume) {
        this.bid = bid;
        this.ask = ask;
        this.last = last;
        this.volume = new Volume(volume);
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public String toString() {
        return "GeminiTicker [bid=" + this.bid + ", ask=" + this.ask + ", last=" + this.last + ", volume=" + this.volume + "]";
    }

    public static class Volume {
        private final Map<String, Object> valueMap;

        public Volume(Map<String, Object> valueMap) {
            this.valueMap = valueMap;
        }

        public long getTimestampMS() {
            return (Long)this.valueMap.get("timestamp");
        }

        public BigDecimal getBaseVolume(CurrencyPair currencyPair) {
            return new BigDecimal((String)this.valueMap.get(currencyPair.base.toString()));
        }

        public BigDecimal getCounterVolume(CurrencyPair currencyPair) {
            return new BigDecimal((String)this.valueMap.get(currencyPair.counter.toString()));
        }
    }
}

