/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.enigma.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.enigma.EnigmaAdapters;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaOrderBook;
import org.knowm.xchange.enigma.model.EnigmaException;
import org.knowm.xchange.enigma.model.EnigmaNotImplementedException;
import org.knowm.xchange.enigma.service.EnigmaMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.CurrencyPairsParam;
import org.knowm.xchange.service.marketdata.params.Params;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnigmaMarketDataService
extends EnigmaMarketDataServiceRaw
implements MarketDataService {
    private static final Logger log = LoggerFactory.getLogger(EnigmaMarketDataService.class);

    public EnigmaMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return EnigmaAdapters.adaptTicker(this.getEnigmaTicker(currencyPair), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException, EnigmaNotImplementedException {
        EnigmaOrderBook enigmaOrderBook = this.getEnigmaOrderBook(currencyPair.toString().replace("/", "-"));
        return EnigmaAdapters.adaptOrderBook(enigmaOrderBook, currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return EnigmaAdapters.adaptTrades(this.getEnigmaTransactions(), currencyPair);
    }

    public List<Ticker> getTickers(Params params) {
        if (!(params instanceof CurrencyPairsParam)) {
            throw new IllegalArgumentException("Params must be instance of CurrencyPairsParam");
        }
        Collection pairs = ((CurrencyPairsParam)params).getCurrencyPairs();
        return pairs.stream().map(currencyPair -> {
            try {
                return this.getTicker((CurrencyPair)currencyPair, currencyPair);
            }
            catch (IOException e) {
                throw new EnigmaException("Error while fetching ticker");
            }
        }).collect(Collectors.toList());
    }
}

