/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.enigma.dto;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.enigma.model.ResponseException;

public class BaseResponse {
    private static Map<Integer, ResponseException> errorCodes = Arrays.stream(ResponseException.values()).collect(Collectors.toMap(ResponseException::getCode, c -> c));
    private Integer code;
    private String message;
    private Boolean result;

    public BaseResponse(Integer code, String message, boolean result) {
        this.code = code;
        this.message = message;
        this.result = result;
    }

    public int getCode() {
        return this.code;
    }

    public ResponseException getException() {
        if (this.code == null) {
            return null;
        }
        return errorCodes.getOrDefault(this.code, ResponseException.GENERIC);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isResult() {
        return this.result;
    }

    public BaseResponse() {
    }
}

