/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.enigma;

import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.enigma.service.EnigmaAccountService;
import org.knowm.xchange.enigma.service.EnigmaMarketDataService;
import org.knowm.xchange.enigma.service.EnigmaTradeService;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class EnigmaExchange
extends BaseExchange {
    private static final String SSL_URI = "https://api.enigma-securities.io/";
    private static final String HOST = "api.enigma-securities.io";
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();

    protected void initServices() {
        this.marketDataService = new EnigmaMarketDataService((Exchange)this);
        this.tradeService = new EnigmaTradeService((Exchange)this);
        this.accountService = new EnigmaAccountService((Exchange)this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri(SSL_URI);
        exchangeSpecification.setHost(HOST);
        exchangeSpecification.setPort(443);
        exchangeSpecification.setExchangeName("Enigma");
        exchangeSpecification.setExchangeDescription("Enigma Securities REST API integration");
        exchangeSpecification.setShouldLoadRemoteMetaData(false);
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }
}

