/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.enigma;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.knowm.xchange.enigma.Enigma;
import org.knowm.xchange.enigma.dto.BaseResponse;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaOpenOrders;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaOrderBook;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaProduct;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaProductMarketData;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaTicker;
import org.knowm.xchange.enigma.dto.marketdata.EnigmaTransaction;
import org.knowm.xchange.enigma.dto.trade.EnigmaExecuteQuoteRequest;
import org.knowm.xchange.enigma.dto.trade.EnigmaExecutedQuote;
import org.knowm.xchange.enigma.dto.trade.EnigmaLimitOrderRequest;
import org.knowm.xchange.enigma.dto.trade.EnigmaNewOrderRequest;
import org.knowm.xchange.enigma.dto.trade.EnigmaOrderSubmission;
import org.knowm.xchange.enigma.dto.trade.EnigmaQuote;
import org.knowm.xchange.enigma.dto.trade.EnigmaQuoteRequest;
import org.knowm.xchange.enigma.dto.trade.EnigmaWithdrawFundsRequest;
import org.knowm.xchange.enigma.dto.trade.EnigmaWithdrawal;
import org.knowm.xchange.enigma.dto.trade.EnigmaWithdrawalRequest;

@Path(value="")
@Produces(value={"application/json"})
public interface EnigmaAuthenticated
extends Enigma {
    @GET
    @Path(value="product")
    public List<EnigmaProduct> getProducts(@HeaderParam(value="Authorization") String var1) throws IOException;

    @GET
    @Path(value="xchange/indicative/market/data/{product-id}")
    public EnigmaTicker getTicker(@HeaderParam(value="Authorization") String var1, @PathParam(value="product-id") int var2) throws IOException;

    @GET
    @Path(value="xchange/orderbook/{pair}")
    public EnigmaOrderBook getOrderBook(@HeaderParam(value="Authorization") String var1, @PathParam(value="pair") String var2) throws IOException;

    @GET
    @Path(value="order/client/list/false/{infra}")
    public EnigmaTransaction[] getTransactions(@HeaderParam(value="Authorization") String var1, @PathParam(value="infra") String var2) throws IOException;

    @GET
    @Path(value="spot/{product-id}")
    public EnigmaProductMarketData getProductMarketData(@HeaderParam(value="Authorization") String var1, @PathParam(value="product-id") int var2) throws IOException;

    @GET
    @Path(value="risk/limit")
    public Map<String, BigDecimal> getAccountRiskLimits(@HeaderParam(value="Authorization") String var1) throws IOException;

    @POST
    @Path(value="order/new")
    @Consumes(value={"application/json"})
    public EnigmaOrderSubmission submitOrder(@HeaderParam(value="Authorization") String var1, EnigmaNewOrderRequest var2) throws IOException;

    @POST
    @Path(value="order/new")
    @Consumes(value={"application/json"})
    public EnigmaOrderSubmission submitLimitOrder(@HeaderParam(value="Authorization") String var1, EnigmaLimitOrderRequest var2) throws IOException;

    @GET
    @Path(value="xchange/cancel/order/")
    @Consumes(value={"application/json"})
    public BaseResponse cancelOrder(@HeaderParam(value="Authorization") String var1) throws IOException;

    @POST
    @Path(value="rfq/new")
    @Consumes(value={"application/json"})
    public EnigmaQuote askForQuote(@HeaderParam(value="Authorization") String var1, EnigmaQuoteRequest var2) throws IOException;

    @POST
    @Path(value="rfq/execute")
    @Consumes(value={"application/json"})
    public EnigmaExecutedQuote executeQuoteRequest(@HeaderParam(value="Authorization") String var1, EnigmaExecuteQuoteRequest var2) throws IOException;

    @GET
    @Path(value="balance/{infra}")
    public Map<String, BigDecimal> getBalance(@HeaderParam(value="Authorization") String var1, @PathParam(value="infra") String var2) throws IOException;

    @GET
    @Path(value="settlement/list")
    public List<EnigmaWithdrawal> getAllWithdrawals(@HeaderParam(value="Authorization") String var1);

    @POST
    @Path(value="withdrawal/new")
    public EnigmaWithdrawal withdrawal(@HeaderParam(value="Authorization") String var1, EnigmaWithdrawalRequest var2);

    @POST
    @Path(value="settlement/new")
    public EnigmaWithdrawal withdrawal(@HeaderParam(value="Authorization") String var1, EnigmaWithdrawFundsRequest var2);

    @GET
    @Path(value="account/show/currency/{currency}")
    public List<Object> depositAddress(@HeaderParam(value="Authorization") String var1, @PathParam(value="currency") String var2);

    @GET
    @Path(value="xchange/order/open")
    public EnigmaOpenOrders openOrders(@HeaderParam(value="Authorization") String var1);
}

