/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dvchain;

import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.dvchain.service.DVChainMarketDataService;
import org.knowm.xchange.dvchain.service.DVChainTradeService;
import org.knowm.xchange.utils.nonce.CurrentTime1000NonceFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class DVChainExchange
extends BaseExchange {
    private SynchronizedValueFactory<Long> nonceFactory = new CurrentTime1000NonceFactory();

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null && exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox").equals(true)) {
            exchangeSpecification.setSslUri("https://sandbox.trade.dvchain.co");
            exchangeSpecification.setHost("sandbox.trade.dvchain.co");
        }
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://trade.dvchain.co");
        exchangeSpecification.setHost("trade.dvchain.co");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("DVChain");
        exchangeSpecification.setExchangeDescription("DVChain is an OTC provider for a variety of cryptocurrencies.");
        exchangeSpecification.setExchangeSpecificParametersItem("Use_Sandbox", (Object)false);
        return exchangeSpecification;
    }

    protected void initServices() {
        DVChainExchange.concludeHostParams(this.exchangeSpecification);
        DVChainMarketDataService md = new DVChainMarketDataService((Exchange)this);
        this.marketDataService = md;
        this.tradeService = new DVChainTradeService(md, (Exchange)this);
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        DVChainExchange.concludeHostParams(exchangeSpecification);
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }
}

