/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coingi.CoingiAdapters;
import org.knowm.xchange.coingi.CoingiErrorAdapter;
import org.knowm.xchange.coingi.dto.CoingiException;
import org.knowm.xchange.coingi.dto.trade.CoingiCancelOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderHistoryRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiGetOrderRequest;
import org.knowm.xchange.coingi.dto.trade.CoingiOrder;
import org.knowm.xchange.coingi.dto.trade.CoingiOrdersList;
import org.knowm.xchange.coingi.dto.trade.CoingiPlaceLimitOrderRequest;
import org.knowm.xchange.coingi.service.CoingiTradeHistoryParams;
import org.knowm.xchange.coingi.service.CoingiTradeServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultOpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class CoingiTradeService
extends CoingiTradeServiceRaw
implements TradeService {
    public CoingiTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        try {
            CoingiGetOrderHistoryRequest orderHistoryRequest = new CoingiGetOrderHistoryRequest();
            orderHistoryRequest.setStatus(0);
            orderHistoryRequest.setPageNumber(1);
            orderHistoryRequest.setPageSize(50);
            CoingiOrdersList list = this.getCoingiOrderHistory(orderHistoryRequest);
            return CoingiAdapters.adaptOpenOrders(list);
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public String placeMarketOrder(MarketOrder order) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public String placeLimitOrder(LimitOrder order) throws IOException {
        try {
            CoingiPlaceLimitOrderRequest request = new CoingiPlaceLimitOrderRequest().setCurrencyPair(CoingiAdapters.adaptCurrency(order.getCurrencyPair())).setOrderType(order.getType().equals((Object)Order.OrderType.BID) ? 0 : 1).setPrice(order.getLimitPrice()).setVolume(order.getOriginalAmount());
            return this.placeCoingiLimitOrder(request).getResult();
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(String orderId) throws IOException {
        try {
            CoingiCancelOrderRequest request = new CoingiCancelOrderRequest();
            request.setOrderId(orderId);
            return this.cancelCoingiOrder(request) != null;
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        try {
            if (orderParams instanceof CancelOrderByIdParams) {
                return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
            }
            return false;
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public UserTrades getTradeHistory(TradeHistoryParams p) throws IOException {
        try {
            if (p instanceof CoingiTradeHistoryParams) {
                CoingiTradeHistoryParams params = (CoingiTradeHistoryParams)p;
                CoingiGetOrderHistoryRequest request = new CoingiGetOrderHistoryRequest();
                if (params.getCurrencyPair() != null) {
                    request.setCurrencyPair(params.getCurrencyPair());
                }
                request.setPageNumber(params.getPageNumber());
                request.setPageSize(params.getPageSize());
                if (params.getStatus() != null) {
                    request.setStatus(params.getStatus());
                }
                if (params.getType() != null) {
                    request.setType(params.getType());
                }
                CoingiOrdersList orderList = this.getCoingiOrderHistory(request);
                return CoingiAdapters.adaptTradeHistory(orderList);
            }
            return null;
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new CoingiTradeHistoryParams(null, 1, 30, null, null);
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return new DefaultOpenOrdersParamCurrencyPair();
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        try {
            ArrayList<Order> orders = new ArrayList<Order>();
            for (String orderId : orderIds) {
                CoingiGetOrderRequest request = new CoingiGetOrderRequest().setOrderId(orderId);
                CoingiOrder coingiOrder = this.getCoingiOrder(request);
                CurrencyPair currencyPair = CoingiAdapters.adaptCurrency(coingiOrder.getCurrencyPair());
                Date date = new Date(coingiOrder.getTimestamp() * 1000L);
                LimitOrder order = new LimitOrder(coingiOrder.getType() == 0 ? Order.OrderType.BID : Order.OrderType.ASK, coingiOrder.getOriginalBaseAmount(), currencyPair, coingiOrder.getId(), date, coingiOrder.getPrice());
                order.setOrderStatus(CoingiAdapters.adaptOrderStatus(coingiOrder.getStatus()));
                orders.add((Order)order);
            }
            return orders;
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }
}

