/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coingi.CoingiAdapters;
import org.knowm.xchange.coingi.CoingiErrorAdapter;
import org.knowm.xchange.coingi.dto.CoingiException;
import org.knowm.xchange.coingi.dto.marketdata.CoingiOrderBook;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTicker;
import org.knowm.xchange.coingi.dto.marketdata.CoingiTransaction;
import org.knowm.xchange.coingi.service.CoingiMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class CoingiMarketDataService
extends CoingiMarketDataServiceRaw
implements MarketDataService {
    public CoingiMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... objects) throws IOException {
        List<CoingiTicker> tickers = this.getTickers(currencyPair, 2, 1);
        OrderBook orderBook = this.getOrderBook(currencyPair, new Object[0]);
        return CoingiAdapters.adaptTicker(tickers, orderBook, currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            int maxAskCount = 100;
            int maxBidCount = 100;
            int maxDepthRangeCount = 32;
            if (args.length > 0) {
                maxAskCount = (Integer)args[0];
                if (args.length > 1) {
                    maxBidCount = (Integer)args[1];
                }
                if (args.length > 2) {
                    maxDepthRangeCount = (Integer)args[2];
                }
                if (args.length > 3) {
                    throw new IllegalArgumentException("getOrderBook() accepts up to 3 optional arguments, but " + args.length + " were passed!");
                }
            }
            CoingiOrderBook orderBook = this.getCoingiOrderBook(currencyPair, maxAskCount, maxBidCount, maxDepthRangeCount);
            return CoingiAdapters.adaptOrderBook(orderBook);
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            int maxCount = 100;
            if (args.length == 1) {
                maxCount = (Integer)args[0];
            }
            List<CoingiTransaction> transactions = this.getTransactions(currencyPair, maxCount);
            return CoingiAdapters.adaptTrades(transactions, currencyPair);
        }
        catch (CoingiException e) {
            throw CoingiErrorAdapter.adapt(e);
        }
    }
}

