/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.service;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CoingiDefaultIdentityProvider {
    private static final String ALGO = "HmacSHA256";
    private static final Charset CHARSET = Charset.forName("US-ASCII");
    private final byte[] publicKey;
    private final Mac sha256HMAC;

    public CoingiDefaultIdentityProvider(byte[] publicKey, byte[] privateKey) {
        Objects.requireNonNull(publicKey, "No public key given.");
        if (publicKey.length == 0) {
            throw new IllegalArgumentException("Empty public key given.");
        }
        this.publicKey = publicKey;
        try {
            Objects.requireNonNull(privateKey, "No private key given.");
            if (privateKey.length == 0) {
                throw new IllegalArgumentException("Empty private key given.");
            }
            this.sha256HMAC = Mac.getInstance(ALGO);
            this.sha256HMAC.init(new SecretKeySpec(privateKey, ALGO));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalArgumentException("Invalid private key.", ex);
        }
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public synchronized String getSignature(long nonce) {
        return HexEncoder.encode(this.sha256HMAC.doFinal(this.buildSignatureData(nonce))).toLowerCase(Locale.ROOT);
    }

    byte[] buildSignatureData(long nonce) {
        byte[] nonceData = String.valueOf(nonce).getBytes(CHARSET);
        byte[] data = new byte[nonceData.length + 1 + this.publicKey.length];
        System.arraycopy(nonceData, 0, data, 0, nonceData.length);
        data[nonceData.length] = 36;
        System.arraycopy(this.publicKey, 0, data, nonceData.length + 1, this.publicKey.length);
        return data;
    }

    public static class HexEncoder {
        private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

        public static String encode(byte[] data) {
            char[] hexChars = new char[data.length * 2];
            int position = 0;
            for (byte bt : data) {
                hexChars[position++] = hexArray[(bt & 0xF0) >>> 4];
                hexChars[position++] = hexArray[bt & 0xF];
            }
            return String.valueOf(hexChars);
        }
    }
}

