/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coingi.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.knowm.xchange.coingi.dto.marketdata.CoingiDepthRange;
import org.knowm.xchange.coingi.dto.marketdata.CoingiOrderGroup;

public class CoingiOrderBook {
    private Collection<CoingiOrderGroup> asks;
    private Collection<CoingiOrderGroup> bids;
    private List<CoingiDepthRange> askDepthRange;
    private List<CoingiDepthRange> bidDepthRange;

    public CoingiOrderBook(@JsonProperty(value="asks") Collection<CoingiOrderGroup> asks, @JsonProperty(value="bids") Collection<CoingiOrderGroup> bids, @JsonProperty(value="askDepthRange") List<CoingiDepthRange> askDepthRange, @JsonProperty(value="bidDepthRange") List<CoingiDepthRange> bidDepthRange) {
        this.asks = Objects.requireNonNull(asks);
        this.bids = Objects.requireNonNull(bids);
        this.askDepthRange = Objects.requireNonNull(askDepthRange);
        this.bidDepthRange = Objects.requireNonNull(bidDepthRange);
    }

    public Collection<CoingiOrderGroup> getAsks() {
        return Collections.unmodifiableCollection(this.asks);
    }

    public Collection<CoingiOrderGroup> getBids() {
        return Collections.unmodifiableCollection(this.bids);
    }

    public Collection<CoingiDepthRange> getAskDepthRange() {
        return Collections.unmodifiableCollection(this.askDepthRange);
    }

    public Collection<CoingiDepthRange> getBidDepthRange() {
        return Collections.unmodifiableCollection(this.bidDepthRange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoingiOrderBook coingiOrderBook = (CoingiOrderBook)o;
        return Objects.equals(this.asks, coingiOrderBook.asks) && Objects.equals(this.bids, coingiOrderBook.bids) && Objects.equals(this.askDepthRange, coingiOrderBook.askDepthRange) && Objects.equals(this.bidDepthRange, coingiOrderBook.bidDepthRange);
    }

    public int hashCode() {
        return Objects.hash(this.asks, this.bids, this.askDepthRange, this.bidDepthRange);
    }
}

