/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbaseProAdapters;
import org.knowm.xchange.coinbasepro.CoinbaseProExchange;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTrades;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductTicker;
import org.knowm.xchange.coinbasepro.service.CoinbaseProMarketDataServiceRaw;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.RateLimitExceededException;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.Params;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoinbaseProMarketDataService
extends CoinbaseProMarketDataServiceRaw
implements MarketDataService {
    private static final Logger log = LoggerFactory.getLogger(CoinbaseProMarketDataService.class);

    public CoinbaseProMarketDataService(CoinbaseProExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException, RateLimitExceededException {
        CoinbaseProProductTicker ticker = this.getCoinbaseProProductTicker(currencyPair);
        CoinbaseProProductStats stats = this.getCoinbaseProProductStats(currencyPair);
        return CoinbaseProAdapters.adaptTicker(ticker, stats, currencyPair);
    }

    public List<Ticker> getTickers(Params params) throws IOException, RateLimitExceededException {
        return CoinbaseProAdapters.adaptTickers(this.getCoinbaseProStats());
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException, RateLimitExceededException {
        int level = 3;
        if (args != null && args.length > 0) {
            if (args[0] instanceof Number) {
                Number arg = (Number)args[0];
                level = arg.intValue();
            } else {
                throw new IllegalArgumentException("Extra argument #1, the 'level', must be an int (was " + args[0].getClass() + ")");
            }
        }
        return CoinbaseProAdapters.adaptOrderBook(this.getCoinbaseProProductOrderBook(currencyPair, level), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException, RateLimitExceededException {
        if (args.length == 0) {
            return CoinbaseProAdapters.adaptTrades(this.getCoinbaseProTrades(currencyPair), currencyPair);
        }
        if (args.length == 2 && args[0] instanceof Long && args[1] instanceof Long) {
            CoinbaseProTrades CoinbaseProTradesNew;
            Long fromTradeId = (Long)args[0];
            Long toTradeId = (Long)args[1];
            log.debug("fromTradeId: {}, toTradeId: {}", (Object)fromTradeId, (Object)toTradeId);
            Long latestTradeId = toTradeId;
            CoinbaseProTrades CoinbaseProTrades2 = new CoinbaseProTrades();
            do {
                CoinbaseProTradesNew = this.getCoinbaseProTradesExtended(currencyPair, latestTradeId, 100);
                CoinbaseProTrades2.addAll(CoinbaseProTradesNew);
                log.debug("latestTradeId: {}, earliest-latest: {}-{}, trades: {}", new Object[]{latestTradeId, CoinbaseProTrades2.getEarliestTradeId(), CoinbaseProTrades2.getLatestTradeId(), CoinbaseProTrades2});
                latestTradeId = CoinbaseProTrades2.getEarliestTradeId();
            } while (CoinbaseProTradesNew.getEarliestTradeId() != null && CoinbaseProTrades2.getEarliestTradeId() > fromTradeId);
            log.debug("earliest-latest: {}-{}", (Object)CoinbaseProTrades2.getEarliestTradeId(), (Object)CoinbaseProTrades2.getLatestTradeId());
            CoinbaseProTrades2.forEach(s -> log.debug(s.toString()));
            return CoinbaseProAdapters.adaptTrades(CoinbaseProTrades2, currencyPair);
        }
        throw new IllegalArgumentException("Invalid arguments passed to getTrades");
    }
}

