/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceOrder;

public class CoinbaseProPlaceLimitOrder
extends CoinbaseProPlaceOrder {
    @JsonProperty(value="price")
    BigDecimal price;
    @JsonProperty(value="size")
    BigDecimal size;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="time_in_force")
    TimeInForce timeInForce;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="cancel_after")
    CancelAfter cancelAfter;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="post_only")
    Boolean postOnly;

    public CoinbaseProPlaceLimitOrder(String clientOld, CoinbaseProPlaceOrder.Type type, CoinbaseProPlaceOrder.Side side, String productId, CoinbaseProPlaceOrder.SelfTradePrevention stp, CoinbaseProPlaceOrder.Stop stop, BigDecimal stopPrice, BigDecimal price, BigDecimal size, TimeInForce timeInForce, CancelAfter cancelAfter, Boolean postOnly) {
        super(clientOld, type, side, productId, stp, stop, stopPrice);
        this.price = price;
        this.size = size;
        this.timeInForce = timeInForce;
        this.cancelAfter = cancelAfter;
        this.postOnly = postOnly;
        if (cancelAfter != null && timeInForce != TimeInForce.GTT) {
            throw new IllegalArgumentException("cancel_after Requires time_in_force to be GTT");
        }
        if (postOnly != null && (timeInForce == TimeInForce.IOC || timeInForce == TimeInForce.FOK)) {
            throw new IllegalArgumentException("post_only Invalid when time_in_force is IOC or FOK");
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public CancelAfter getCancelAfter() {
        return this.cancelAfter;
    }

    public Boolean getPostOnly() {
        return this.postOnly;
    }

    public String toString() {
        return "CoinbaseProPlaceLimitOrder [price=" + this.price + ", size=" + this.size + ", timeInForce=" + (Object)((Object)this.timeInForce) + ", cancelAfter=" + (Object)((Object)this.cancelAfter) + ", postOnly=" + this.postOnly + ", clientOid=" + this.clientOid + ", type=" + (Object)((Object)this.type) + ", side=" + (Object)((Object)this.side) + ", productId=" + this.productId + ", stp=" + (Object)((Object)this.stp) + ", stop=" + (Object)((Object)this.stop) + ", stopPrice=" + this.stopPrice + "]";
    }

    public static enum TimeInForce {
        GTC,
        GTT,
        IOC,
        FOK;

    }

    public static enum CancelAfter {
        min,
        hour,
        day;

    }

    public static class Builder
    extends CoinbaseProPlaceOrder.Builder<CoinbaseProPlaceLimitOrder, Builder> {
        BigDecimal price;
        BigDecimal size;
        TimeInForce timeInForce;
        CancelAfter cancelAfter;
        Boolean postOnly;

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder size(BigDecimal size) {
            this.size = size;
            return this;
        }

        public Builder timeInForce(TimeInForce timeInForce) {
            this.timeInForce = timeInForce;
            return this;
        }

        public Builder cancelAfter(CancelAfter cancelAfter) {
            this.cancelAfter = cancelAfter;
            return this;
        }

        public Builder postOnly(boolean postOnly) {
            this.postOnly = postOnly;
            return this;
        }

        @Override
        public CoinbaseProPlaceLimitOrder build() {
            return new CoinbaseProPlaceLimitOrder(this.clientOid, this.type, this.side, this.productId, this.stp, this.stop, this.stopPrice, this.price, this.size, this.timeInForce, this.cancelAfter, this.postOnly);
        }
    }
}

