/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.knowm.xchange.dto.account.FundingRecord;

public class CoinbaseProTransfer {
    public final String id;
    public final String type;
    public final String createdAt;
    public final String completedAt;
    public final String canceledAt;
    public final String processedAt;
    public final String accountId;
    public final String userId;
    public final String userNonce;
    public final String amount;
    public final Detail details;

    public CoinbaseProTransfer(@JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="completed_at") String completedAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="processed_at") String processedAt, @JsonProperty(value="account_id") String accountId, @JsonProperty(value="user_id") String userId, @JsonProperty(value="user_nonce") String userNonce, @JsonProperty(value="amount") String amount, @JsonProperty(value="details") Detail details) {
        this.id = id;
        this.type = type;
        this.createdAt = createdAt;
        this.completedAt = completedAt;
        this.canceledAt = canceledAt;
        this.processedAt = processedAt;
        this.accountId = accountId;
        this.userId = userId;
        this.userNonce = userNonce;
        this.amount = amount;
        this.details = details;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public FundingRecord.Type type() {
        return this.type.equalsIgnoreCase("withdraw") ? FundingRecord.Type.WITHDRAWAL : FundingRecord.Type.DEPOSIT;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Date createdAt() {
        return CoinbaseProTransfer.parse(this.createdAt);
    }

    public String getCompletedAt() {
        return this.completedAt;
    }

    public Date completedAt() {
        return CoinbaseProTransfer.parse(this.completedAt);
    }

    public String getCanceledAt() {
        return this.canceledAt;
    }

    public Date canceledAt() {
        return CoinbaseProTransfer.parse(this.canceledAt);
    }

    public String getProcessedAt() {
        return this.processedAt;
    }

    public Date processedAt() {
        return CoinbaseProTransfer.parse(this.processedAt);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserNonce() {
        return this.userNonce;
    }

    public String getAmount() {
        return this.amount;
    }

    public BigDecimal amount() {
        return new BigDecimal(this.amount);
    }

    public Detail getDetails() {
        return this.details;
    }

    private static Date parse(String time) {
        try {
            return time == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ").parse(time + "00");
        }
        catch (ParseException e) {
            throw new IllegalStateException("Cannot parse '" + time + "'", e);
        }
    }

    public String toString() {
        return "CoinbaseProTransfer{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", createdAt='" + this.createdAt + '\'' + ", completedAt='" + this.completedAt + '\'' + ", canceledAt='" + this.canceledAt + '\'' + ", processedAt='" + this.processedAt + '\'' + ", accountId='" + this.accountId + '\'' + ", userId='" + this.userId + '\'' + ", userNonce='" + this.userNonce + '\'' + ", amount='" + this.amount + '\'' + ", details=" + this.details + '}';
    }

    public static class Detail {
        public final String cryptoAddress;
        public final String coinbaseAccountId;
        public final String cryptoTransactionId;
        public final String coinbaseTransactionId;
        public final String cryptoTransactionHash;
        public final String sentToAddress;
        public final String coinbaseWithdrawalId;
        private final String destinationTag;
        private final String destinationTagName;

        public Detail(@JsonProperty(value="crypto_address") String cryptoAddress, @JsonProperty(value="coinbase_account_id") String coinbaseAccountId, @JsonProperty(value="crypto_transaction_id") String cryptoTransactionId, @JsonProperty(value="coinbase_transaction_id") String coinbaseTransactionId, @JsonProperty(value="crypto_transaction_hash") String cryptoTransactionHash, @JsonProperty(value="sent_to_address") String sentToAddress, @JsonProperty(value="coinbase_withdrawal_id") String coinbaseWithdrawalId, @JsonProperty(value="destination_tag") String destinationTag, @JsonProperty(value="destination_tag_name") String destinationTagName) {
            this.cryptoAddress = cryptoAddress;
            this.coinbaseAccountId = coinbaseAccountId;
            this.cryptoTransactionId = cryptoTransactionId;
            this.coinbaseTransactionId = coinbaseTransactionId;
            this.cryptoTransactionHash = cryptoTransactionHash;
            this.sentToAddress = sentToAddress;
            this.coinbaseWithdrawalId = coinbaseWithdrawalId;
            this.destinationTag = destinationTag;
            this.destinationTagName = destinationTagName;
        }

        public String getCryptoAddress() {
            return this.cryptoAddress;
        }

        public String getCoinbaseAccountId() {
            return this.coinbaseAccountId;
        }

        public String getCryptoTransactionId() {
            return this.cryptoTransactionId;
        }

        public String getCoinbaseTransactionId() {
            return this.coinbaseTransactionId;
        }

        public String getCryptoTransactionHash() {
            return this.cryptoTransactionHash;
        }

        public String getSentToAddress() {
            return this.sentToAddress;
        }

        public String getCoinbaseWithdrawalId() {
            return this.coinbaseWithdrawalId;
        }

        public String getDestinationTag() {
            return this.destinationTag;
        }

        public String toString() {
            return "Detail{cryptoAddress='" + this.cryptoAddress + '\'' + ", coinbaseAccountId='" + this.coinbaseAccountId + '\'' + ", cryptoTransactionId='" + this.cryptoTransactionId + '\'' + ", coinbaseTransactionId='" + this.coinbaseTransactionId + '\'' + ", cryptoTransactionHash='" + this.cryptoTransactionHash + '\'' + ", sentToAddress='" + this.sentToAddress + '\'' + ", coinbaseWithdrawalId='" + this.coinbaseWithdrawalId + '\'' + ", destinationTag='" + this.destinationTag + '\'' + ", destinationTagName='" + this.destinationTagName + '\'' + '}';
        }
    }
}

