/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.coinbasepro.CoinbaseProAdapters;
import org.knowm.xchange.coinbasepro.CoinbaseProResilience;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCurrency;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProduct;
import org.knowm.xchange.coinbasepro.service.CoinbaseProAccountService;
import org.knowm.xchange.coinbasepro.service.CoinbaseProMarketDataService;
import org.knowm.xchange.coinbasepro.service.CoinbaseProMarketDataServiceRaw;
import org.knowm.xchange.coinbasepro.service.CoinbaseProTradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public class CoinbaseProExchange
extends BaseExchange {
    private static ResilienceRegistries RESILIENCE_REGISTRIES;

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null) {
            boolean useSandbox = exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox").equals(true);
            boolean usePrime = Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem("Use_Prime"));
            if (useSandbox) {
                if (usePrime) {
                    exchangeSpecification.setSslUri((String)exchangeSpecification.getExchangeSpecificParametersItem("SandboxPrimeSslUri"));
                    exchangeSpecification.setHost((String)exchangeSpecification.getExchangeSpecificParametersItem("SandboxPrimeHost"));
                } else {
                    exchangeSpecification.setSslUri((String)exchangeSpecification.getExchangeSpecificParametersItem("SandboxSslUri"));
                    exchangeSpecification.setHost((String)exchangeSpecification.getExchangeSpecificParametersItem("SandboxHost"));
                }
            } else if (usePrime) {
                exchangeSpecification.setSslUri((String)exchangeSpecification.getExchangeSpecificParametersItem("PrimeSslUri"));
                exchangeSpecification.setHost((String)exchangeSpecification.getExchangeSpecificParametersItem("PrimeHost"));
            }
        }
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        CoinbaseProExchange.concludeHostParams(exchangeSpecification);
    }

    protected void initServices() {
        CoinbaseProExchange.concludeHostParams(this.exchangeSpecification);
        this.marketDataService = new CoinbaseProMarketDataService(this, this.getResilienceRegistries());
        this.accountService = new CoinbaseProAccountService(this, this.getResilienceRegistries());
        this.tradeService = new CoinbaseProTradeService(this, this.getResilienceRegistries());
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://api.pro.coinbase.com");
        exchangeSpecification.setHost("api.pro.coinbase.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("CoinbasePro");
        exchangeSpecification.setExchangeDescription("CoinbasePro Exchange is a Bitcoin exchange, re-branded from GDAX in 2018");
        exchangeSpecification.setExchangeSpecificParametersItem("Use_Sandbox", (Object)false);
        exchangeSpecification.setExchangeSpecificParametersItem("SandboxSslUri", (Object)"https://api-public.sandbox.pro.coinbase.com");
        exchangeSpecification.setExchangeSpecificParametersItem("SandboxHost", (Object)"api-public.sandbox.pro.coinbase.com");
        exchangeSpecification.setExchangeSpecificParametersItem("PrimeSslUri", (Object)"https://api.exchange.coinbase.com");
        exchangeSpecification.setExchangeSpecificParametersItem("PrimeHost", (Object)"api.exchange.coinbase.com");
        exchangeSpecification.setExchangeSpecificParametersItem("SandboxPrimeSslUri", (Object)"https://api-public.sandbox.exchange.coinbase.com");
        exchangeSpecification.setExchangeSpecificParametersItem("SandboxPrimeHost", (Object)"api-public.sandbox.exchange.coinbase.com");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("CoinbasePro uses timestamp rather than a nonce");
    }

    public ResilienceRegistries getResilienceRegistries() {
        if (RESILIENCE_REGISTRIES == null) {
            RESILIENCE_REGISTRIES = CoinbaseProResilience.createRegistries();
        }
        return RESILIENCE_REGISTRIES;
    }

    public void remoteInit() throws IOException {
        CoinbaseProProduct[] products = ((CoinbaseProMarketDataServiceRaw)this.marketDataService).getCoinbaseProProducts();
        CoinbaseProCurrency[] currencies = ((CoinbaseProMarketDataServiceRaw)this.marketDataService).getCoinbaseProCurrencies();
        this.exchangeMetaData = CoinbaseProAdapters.adaptToExchangeMetaData(this.exchangeMetaData, products, currencies);
    }

    public static final class Parameters {
        public static final String PARAM_USE_SANDBOX = "Use_Sandbox";
        public static final String PARAM_SANDBOX_SSL_URI = "SandboxSslUri";
        public static final String PARAM_SANDBOX_HOST = "SandboxHost";
        public static final String PARAM_USE_PRIME = "Use_Prime";
        public static final String PARAM_PRIME_SSL_URI = "PrimeSslUri";
        public static final String PARAM_PRIME_HOST = "PrimeHost";
        public static final String PARAM_SANDBOX_PRIME_SSL_URI = "SandboxPrimeSslUri";
        public static final String PARAM_SANDBOX_PRIME_HOST = "SandboxPrimeHost";
    }
}

