/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.knowm.xchange.coinbasepro.dto.CoinbaseProTransfer;
import org.knowm.xchange.coinbasepro.dto.account.CoinbaseProAccount;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProCurrency;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProduct;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBook;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductBookEntry;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProProductTicker;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProStats;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProTrade;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProFill;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProOrderFlags;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceLimitOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceMarketOrder;
import org.knowm.xchange.coinbasepro.dto.trade.CoinbaseProPlaceOrder;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.WalletHealth;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoinbaseProAdapters {
    private static final Logger logger = LoggerFactory.getLogger(CoinbaseProAdapters.class);

    private CoinbaseProAdapters() {
    }

    protected static Date parseDate(String rawDate) {
        String modified;
        if (rawDate.length() > 23) {
            modified = rawDate.substring(0, 23);
        } else if (rawDate.endsWith("Z")) {
            switch (rawDate.length()) {
                case 20: {
                    modified = rawDate.substring(0, 19) + ".000";
                    break;
                }
                case 22: {
                    modified = rawDate.substring(0, 21) + "00";
                    break;
                }
                case 23: {
                    modified = rawDate.substring(0, 22) + "0";
                    break;
                }
                default: {
                    modified = rawDate;
                    break;
                }
            }
        } else {
            switch (rawDate.length()) {
                case 19: {
                    modified = rawDate + ".000";
                    break;
                }
                case 21: {
                    modified = rawDate + "00";
                    break;
                }
                case 22: {
                    modified = rawDate + "0";
                    break;
                }
                default: {
                    modified = rawDate;
                }
            }
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.parse(modified);
        }
        catch (ParseException e) {
            logger.warn("unable to parse rawDate={} modified={}", new Object[]{rawDate, modified, e});
            return null;
        }
    }

    public static CurrencyPair toCurrencyPair(String productId) {
        String[] parts = productId.split("-");
        return new CurrencyPair(parts[0], parts[1]);
    }

    public static Ticker adaptTicker(CoinbaseProProductTicker ticker, CoinbaseProProductStats stats, CurrencyPair currencyPair) {
        return new Ticker.Builder().instrument((Instrument)currencyPair).last(ticker.getPrice()).open(stats.getOpen()).high(stats.getHigh()).low(stats.getLow()).bid(ticker.getBid()).ask(ticker.getAsk()).volume(ticker.getVolume()).timestamp(CoinbaseProAdapters.parseDate(ticker.getTime())).build();
    }

    public static List<Ticker> adaptTickers(Map<String, CoinbaseProStats> stats) {
        LinkedList<Ticker> tickers = new LinkedList<Ticker>();
        for (String pair : stats.keySet()) {
            CoinbaseProStats pairStats = stats.get(pair);
            tickers.add(new Ticker.Builder().instrument((Instrument)new CurrencyPair(pair)).last(pairStats.getLast()).open(pairStats.getOpen()).high(pairStats.getHigh()).low(pairStats.getLow()).volume(pairStats.getVolume()).build());
        }
        return tickers;
    }

    public static OrderBook adaptOrderBook(CoinbaseProProductBook book, CurrencyPair currencyPair, Date date) {
        List<LimitOrder> asks = CoinbaseProAdapters.toLimitOrderList(book.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = CoinbaseProAdapters.toLimitOrderList(book.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(date, asks, bids);
    }

    public static OrderBook adaptOrderBook(CoinbaseProProductBook book, CurrencyPair currencyPair) {
        return CoinbaseProAdapters.adaptOrderBook(book, currencyPair, null);
    }

    private static List<LimitOrder> toLimitOrderList(CoinbaseProProductBookEntry[] levels, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> allLevels = new ArrayList<LimitOrder>();
        if (levels != null) {
            for (CoinbaseProProductBookEntry ask : levels) {
                allLevels.add(new LimitOrder(orderType, ask.getVolume(), (Instrument)currencyPair, "0", null, ask.getPrice()));
            }
        }
        return allLevels;
    }

    public static Wallet adaptAccountInfo(CoinbaseProAccount[] coinbaseProAccounts) {
        ArrayList<Balance> balances = new ArrayList<Balance>(coinbaseProAccounts.length);
        for (CoinbaseProAccount coinbaseProAccount : coinbaseProAccounts) {
            balances.add(new Balance(Currency.getInstance((String)coinbaseProAccount.getCurrency()), coinbaseProAccount.getBalance(), coinbaseProAccount.getAvailable(), coinbaseProAccount.getHold()));
        }
        return Wallet.Builder.from(balances).id(coinbaseProAccounts[0].getProfile_id()).build();
    }

    public static OpenOrders adaptOpenOrders(CoinbaseProOrder[] coinbaseExOpenOrders) {
        Map<Boolean, List<Order>> twoTypes = Arrays.stream(coinbaseExOpenOrders).map(CoinbaseProAdapters::adaptOrder).collect(Collectors.partitioningBy(t -> t instanceof LimitOrder));
        List<Order> limitOrders = twoTypes.get(true);
        return new OpenOrders(limitOrders, twoTypes.get(false));
    }

    public static Order adaptOrder(CoinbaseProOrder order) {
        Order.OrderType type = "buy".equals(order.getSide()) ? Order.OrderType.BID : Order.OrderType.ASK;
        CurrencyPair currencyPair = new CurrencyPair(order.getProductId().replace('-', '/'));
        Object builder = null;
        if (order.getType() == null) {
            return null;
        }
        switch (order.getType()) {
            case "market": {
                builder = new MarketOrder.Builder(type, (Instrument)currencyPair);
                break;
            }
            case "limit": {
                builder = order.getStop() == null ? new LimitOrder.Builder(type, (Instrument)currencyPair).limitPrice(order.getPrice()) : new StopOrder.Builder(type, (Instrument)currencyPair).stopPrice(order.getStopPrice());
            }
        }
        if (builder == null) {
            return null;
        }
        builder.orderStatus(CoinbaseProAdapters.adaptOrderStatus(order)).originalAmount(order.getSize()).id(order.getId()).timestamp(CoinbaseProAdapters.parseDate(order.getCreatedAt())).cumulativeAmount(order.getFilledSize()).fee(order.getFillFees());
        BigDecimal averagePrice = order.getFilledSize().signum() != 0 && order.getExecutedvalue().signum() != 0 ? order.getExecutedvalue().divide(order.getFilledSize(), MathContext.DECIMAL32) : BigDecimal.ZERO;
        return builder.averagePrice(averagePrice).build();
    }

    public static Order.OrderStatus[] adaptOrderStatuses(CoinbaseProOrder[] orders) {
        Order.OrderStatus[] orderStatuses = new Order.OrderStatus[orders.length];
        int i = 0;
        for (CoinbaseProOrder coinbaseProOrder : orders) {
            orderStatuses[i++] = CoinbaseProAdapters.adaptOrderStatus(coinbaseProOrder);
        }
        return orderStatuses;
    }

    public static Order.OrderStatus adaptOrderStatus(CoinbaseProOrder order) {
        if (order.getStatus() == null) {
            return Order.OrderStatus.UNKNOWN;
        }
        switch (order.getStatus()) {
            case "pending": {
                return Order.OrderStatus.PENDING_NEW;
            }
            case "done": 
            case "settled": {
                if (order.getDoneReason() == null) {
                    return Order.OrderStatus.UNKNOWN;
                }
                switch (order.getDoneReason()) {
                    case "filled": {
                        return Order.OrderStatus.FILLED;
                    }
                    case "canceled": {
                        return Order.OrderStatus.CANCELED;
                    }
                }
                return Order.OrderStatus.UNKNOWN;
            }
        }
        if (order.getFilledSize().signum() == 0) {
            if ("open".equals(order.getStatus()) && order.getStop() != null) {
                return Order.OrderStatus.STOPPED;
            }
            return Order.OrderStatus.NEW;
        }
        if (order.getFilledSize().compareTo(BigDecimal.ZERO) > 0 && order.getSize().compareTo(order.getFilledSize()) >= 0) {
            return Order.OrderStatus.PARTIALLY_FILLED;
        }
        return Order.OrderStatus.UNKNOWN;
    }

    public static Trades adaptTrades(List<CoinbaseProTrade> coinbaseProTradesList, CurrencyPair currencyPair) {
        CoinbaseProTrade[] tradeArray = new CoinbaseProTrade[coinbaseProTradesList.size()];
        coinbaseProTradesList.toArray(tradeArray);
        return CoinbaseProAdapters.adaptTrades(tradeArray, currencyPair);
    }

    public static UserTrades adaptTradeHistory(List<CoinbaseProFill> coinbaseExFills) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(coinbaseExFills.size());
        for (CoinbaseProFill fill : coinbaseExFills) {
            CurrencyPair currencyPair = new CurrencyPair(fill.getProductId().replace('-', '/'));
            trades.add(new UserTrade.Builder().type("buy".equals(fill.getSide()) ? Order.OrderType.BID : Order.OrderType.ASK).originalAmount(fill.getSize()).currencyPair(currencyPair).price(fill.getPrice()).timestamp(CoinbaseProAdapters.parseDate(fill.getCreatedAt())).id(String.valueOf(fill.getTradeId())).orderId(fill.getOrderId()).feeAmount(fill.getFee()).feeCurrency(currencyPair.counter).build());
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByID);
    }

    public static Trades adaptTrades(CoinbaseProTrade[] coinbaseExTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>(coinbaseExTrades.length);
        for (CoinbaseProTrade trade : coinbaseExTrades) {
            Order.OrderType type = "sell".equals(trade.getSide()) ? Order.OrderType.BID : Order.OrderType.ASK;
            trades.add(new Trade.Builder().type(type).originalAmount(trade.getSize()).price(trade.getPrice()).instrument((Instrument)currencyPair).timestamp(CoinbaseProAdapters.parseDate(trade.getTimestamp())).id(String.valueOf(trade.getTradeId())).makerOrderId(trade.getMakerOrderId()).takerOrderId(trade.getTakerOrderId()).build());
        }
        return new Trades(trades, coinbaseExTrades[0].getTradeId(), Trades.TradeSortType.SortByID);
    }

    public static CurrencyPair adaptCurrencyPair(CoinbaseProProduct product) {
        return new CurrencyPair(product.getBaseCurrency(), product.getTargetCurrency());
    }

    private static Currency adaptCurrency(CoinbaseProCurrency currency) {
        return new Currency(currency.getId());
    }

    private static int numberOfDecimals(BigDecimal value) {
        double d = value.doubleValue();
        return -((int)Math.round(Math.log10(d)));
    }

    public static ExchangeMetaData adaptToExchangeMetaData(ExchangeMetaData exchangeMetaData, CoinbaseProProduct[] products, CoinbaseProCurrency[] cbCurrencies) {
        Map<CurrencyPair, CurrencyPairMetaData> currencyPairs = exchangeMetaData == null ? new HashMap() : exchangeMetaData.getCurrencyPairs();
        Map currencies = exchangeMetaData == null ? new HashMap() : exchangeMetaData.getCurrencies();
        for (CoinbaseProProduct product : products) {
            if (!"online".equals(product.getStatus())) continue;
            CurrencyPair pair = CoinbaseProAdapters.adaptCurrencyPair(product);
            CurrencyPairMetaData staticMetaData = (CurrencyPairMetaData)currencyPairs.get(pair);
            int baseScale = CoinbaseProAdapters.numberOfDecimals(product.getBaseIncrement());
            int priceScale = CoinbaseProAdapters.numberOfDecimals(product.getQuoteIncrement());
            boolean marketOrderAllowed = !product.isLimitOnly();
            currencyPairs.put(pair, new CurrencyPairMetaData(new BigDecimal("0.50"), product.getBaseMinSize(), product.getBaseMaxSize(), product.getMinMarketFunds(), product.getMaxMarketFunds(), Integer.valueOf(baseScale), Integer.valueOf(priceScale), null, staticMetaData != null ? staticMetaData.getFeeTiers() : null, null, pair.counter, marketOrderAllowed));
        }
        Arrays.stream(cbCurrencies).forEach(currency -> currencies.put(CoinbaseProAdapters.adaptCurrency(currency), new CurrencyMetaData(Integer.valueOf(CoinbaseProAdapters.numberOfDecimals(currency.getMaxPrecision())), BigDecimal.ZERO, currency.getDetails().getMinWithdrawalAmount(), "online".equals(currency.getStatus()) ? WalletHealth.ONLINE : WalletHealth.OFFLINE)));
        return new ExchangeMetaData(currencyPairs, currencies, exchangeMetaData == null ? null : exchangeMetaData.getPublicRateLimits(), exchangeMetaData == null ? null : exchangeMetaData.getPrivateRateLimits(), Boolean.valueOf(true));
    }

    public static String adaptProductID(CurrencyPair currencyPair) {
        return currencyPair == null ? null : currencyPair.base.getCurrencyCode() + "-" + currencyPair.counter.getCurrencyCode();
    }

    public static CoinbaseProPlaceOrder.Side adaptSide(Order.OrderType orderType) {
        return orderType == Order.OrderType.ASK ? CoinbaseProPlaceOrder.Side.sell : CoinbaseProPlaceOrder.Side.buy;
    }

    public static CoinbaseProPlaceOrder.Stop adaptStop(Order.OrderType orderType) {
        return orderType == Order.OrderType.ASK ? CoinbaseProPlaceOrder.Stop.loss : CoinbaseProPlaceOrder.Stop.entry;
    }

    public static CoinbaseProPlaceLimitOrder adaptCoinbaseProPlaceLimitOrder(LimitOrder limitOrder) {
        CoinbaseProPlaceLimitOrder.Builder builder = ((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)new CoinbaseProPlaceLimitOrder.Builder().clientOid(limitOrder.getUserReference())).price(limitOrder.getLimitPrice()).type(CoinbaseProPlaceOrder.Type.limit)).productId(CoinbaseProAdapters.adaptProductID(limitOrder.getCurrencyPair()))).side(CoinbaseProAdapters.adaptSide(limitOrder.getType()))).size(limitOrder.getOriginalAmount());
        if (limitOrder.getOrderFlags().contains((Object)CoinbaseProOrderFlags.POST_ONLY)) {
            builder.postOnly(true);
        }
        if (limitOrder.getOrderFlags().contains((Object)CoinbaseProOrderFlags.FILL_OR_KILL)) {
            builder.timeInForce(CoinbaseProPlaceLimitOrder.TimeInForce.FOK);
        }
        if (limitOrder.getOrderFlags().contains((Object)CoinbaseProOrderFlags.IMMEDIATE_OR_CANCEL)) {
            builder.timeInForce(CoinbaseProPlaceLimitOrder.TimeInForce.IOC);
        }
        return builder.build();
    }

    public static CoinbaseProPlaceMarketOrder adaptCoinbaseProPlaceMarketOrder(MarketOrder marketOrder) {
        return ((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)new CoinbaseProPlaceMarketOrder.Builder().productId(CoinbaseProAdapters.adaptProductID(marketOrder.getCurrencyPair()))).clientOid(marketOrder.getUserReference())).type(CoinbaseProPlaceOrder.Type.market)).side(CoinbaseProAdapters.adaptSide(marketOrder.getType()))).size(marketOrder.getOriginalAmount()).build();
    }

    public static CoinbaseProPlaceOrder adaptCoinbaseProStopOrder(StopOrder stopOrder) {
        if (stopOrder.getLimitPrice() == null) {
            return ((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)((CoinbaseProPlaceMarketOrder.Builder)new CoinbaseProPlaceMarketOrder.Builder().productId(CoinbaseProAdapters.adaptProductID(stopOrder.getCurrencyPair()))).clientOid(stopOrder.getUserReference())).type(CoinbaseProPlaceOrder.Type.market)).side(CoinbaseProAdapters.adaptSide(stopOrder.getType()))).size(stopOrder.getOriginalAmount()).stop(CoinbaseProAdapters.adaptStop(stopOrder.getType()))).stopPrice(stopOrder.getStopPrice())).build();
        }
        return ((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)((CoinbaseProPlaceLimitOrder.Builder)new CoinbaseProPlaceLimitOrder.Builder().productId(CoinbaseProAdapters.adaptProductID(stopOrder.getCurrencyPair()))).clientOid(stopOrder.getUserReference())).type(CoinbaseProPlaceOrder.Type.limit)).side(CoinbaseProAdapters.adaptSide(stopOrder.getType()))).size(stopOrder.getOriginalAmount()).stop(CoinbaseProAdapters.adaptStop(stopOrder.getType()))).stopPrice(stopOrder.getStopPrice())).price(stopOrder.getLimitPrice()).build();
    }

    public static FundingRecord adaptFundingRecord(Currency currency, CoinbaseProTransfer coinbaseProTransfer) {
        FundingRecord.Status status = FundingRecord.Status.PROCESSING;
        Date processedAt = coinbaseProTransfer.processedAt();
        Date canceledAt = coinbaseProTransfer.canceledAt();
        if (canceledAt != null) {
            status = FundingRecord.Status.CANCELLED;
        } else if (processedAt != null) {
            status = FundingRecord.Status.COMPLETE;
        }
        String address = coinbaseProTransfer.getDetails().getCryptoAddress();
        if (address == null) {
            address = coinbaseProTransfer.getDetails().getSentToAddress();
        }
        String cryptoTransactionHash = coinbaseProTransfer.getDetails().getCryptoTransactionHash();
        String transactionHash = CoinbaseProAdapters.adaptTransactionHash(currency.getSymbol(), cryptoTransactionHash);
        return new FundingRecord(address, coinbaseProTransfer.getDetails().getDestinationTag(), coinbaseProTransfer.createdAt(), currency, coinbaseProTransfer.amount(), coinbaseProTransfer.getId(), transactionHash, coinbaseProTransfer.type(), status, null, null, null);
    }

    private static String adaptTransactionHash(String currency, String transactionHash) {
        switch (currency) {
            case "ZRX": 
            case "BAT": 
            case "LOOM": 
            case "CVC": 
            case "DNT": 
            case "MANA": 
            case "GNT": 
            case "REP": 
            case "LINK": 
            case "ETH": 
            case "ETC": 
            case "USDC": 
            case "DAI": 
            case "ZIL": 
            case "MKR": {
                transactionHash = transactionHash != null ? "0x" + transactionHash : null;
            }
        }
        return transactionHash;
    }
}

