/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto.trade;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;

public abstract class CoinbaseProPlaceOrder {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="client_oid")
    String clientOid;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="type")
    Type type;
    @JsonProperty(value="side")
    Side side;
    @JsonProperty(value="product_id")
    String productId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="stp")
    SelfTradePrevention stp;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="stop")
    Stop stop;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="stop_price")
    BigDecimal stopPrice;

    public CoinbaseProPlaceOrder(String clientOid, Type type, Side side, String productId, SelfTradePrevention stp, Stop stop, BigDecimal stopPrice) {
        this.clientOid = clientOid;
        this.type = type;
        this.side = side;
        this.productId = productId;
        this.stp = stp;
        this.stop = stop;
        this.stopPrice = stopPrice;
    }

    public String getClientOid() {
        return this.clientOid;
    }

    public Type getType() {
        return this.type;
    }

    public Side getSide() {
        return this.side;
    }

    public String getProductId() {
        return this.productId;
    }

    public SelfTradePrevention getStp() {
        return this.stp;
    }

    public Stop getStop() {
        return this.stop;
    }

    public BigDecimal getStopPrice() {
        return this.stopPrice;
    }

    public static enum Type {
        limit,
        market;

    }

    public static enum Side {
        buy,
        sell;

    }

    public static enum SelfTradePrevention {
        dc,
        co,
        cn,
        cb;

    }

    public static enum Stop {
        loss,
        entry;

    }

    static abstract class Builder<T, B extends Builder<?, ?>> {
        String clientOid;
        Type type;
        Side side;
        String productId;
        SelfTradePrevention stp;
        Stop stop;
        BigDecimal stopPrice;

        Builder() {
        }

        public B clientOid(String clientOid) {
            this.clientOid = clientOid;
            return (B)this;
        }

        public B type(Type type) {
            this.type = type;
            return (B)this;
        }

        public B side(Side side) {
            this.side = side;
            return (B)this;
        }

        public B productId(String productId) {
            this.productId = productId;
            return (B)this;
        }

        public B stp(SelfTradePrevention stp) {
            this.stp = stp;
            return (B)this;
        }

        public B stop(Stop stop) {
            this.stop = stop;
            return (B)this;
        }

        public B stopPrice(BigDecimal stopPrice) {
            this.stopPrice = stopPrice;
            return (B)this;
        }

        public abstract T build();
    }
}

