/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbasepro.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.coinbasepro.dto.marketdata.CoinbaseProTrade;
import si.mazi.rescu.HttpResponseAware;

public class CoinbaseProTrades
extends ArrayList<CoinbaseProTrade>
implements HttpResponseAware {
    private static final long serialVersionUID = 8072963227369004488L;
    private Map<String, List<String>> headers;
    private Long earliestTradeId = null;
    private Long latestTradeId = null;

    public boolean addAll(CoinbaseProTrades coinbaseProTrades) {
        if (this.earliestTradeId == null) {
            this.earliestTradeId = coinbaseProTrades.getEarliestTradeId();
        } else if (coinbaseProTrades.getEarliestTradeId() != null) {
            this.earliestTradeId = Math.min(this.earliestTradeId, coinbaseProTrades.getEarliestTradeId());
        }
        if (this.latestTradeId == null) {
            this.latestTradeId = coinbaseProTrades.getLatestTradeId();
        } else if (coinbaseProTrades.getLatestTradeId() != null) {
            this.latestTradeId = Math.max(this.latestTradeId, coinbaseProTrades.getLatestTradeId());
        }
        return super.addAll(coinbaseProTrades);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        this.earliestTradeId = this.getHeaderAsLong("Cb-After");
        this.latestTradeId = this.getHeaderAsLong("Cb-Before");
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.headers;
    }

    public Long getHeaderAsLong(String key) {
        Long header = null;
        try {
            header = Long.valueOf(this.getResponseHeaders().get(key).get(0));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return header;
    }

    public Long getEarliestTradeId() {
        return this.earliestTradeId;
    }

    public Long getLatestTradeId() {
        return this.latestTradeId;
    }
}

