/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.CoinbaseAdapters;
import org.knowm.xchange.coinbase.v2.dto.account.transactions.CoinbaseBuySellResponse;
import org.knowm.xchange.coinbase.v2.service.CoinbaseTradeHistoryParams;
import org.knowm.xchange.coinbase.v2.service.CoinbaseTradeServiceRaw;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public final class CoinbaseTradeService
extends CoinbaseTradeServiceRaw
implements TradeService {
    public CoinbaseTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws NotAvailableFromExchangeException, IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws NotAvailableFromExchangeException {
        throw new NotAvailableFromExchangeException();
    }

    public String placeStopOrder(StopOrder stopOrder) throws IOException {
        throw new NotAvailableFromExchangeException();
    }

    public boolean cancelOrder(String orderId) throws NotAvailableFromExchangeException {
        throw new NotAvailableFromExchangeException();
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotAvailableFromExchangeException();
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return new CoinbaseTradeHistoryParams();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public UserTrades getBuyTradeHistory(CoinbaseTradeHistoryParams params, String accountId) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        CoinbaseBuySellResponse buys = this.coinbase.getBuys("2018-04-08", apiKey, this.signatureCreator2, timestamp, accountId, params.getLimit(), params.getStartId());
        return CoinbaseAdapters.adaptTrades(buys.getData(), Order.OrderType.BID);
    }

    public UserTrades getSellTradeHistory(CoinbaseTradeHistoryParams params, String accountId) throws IOException {
        String apiKey = this.exchange.getExchangeSpecification().getApiKey();
        BigDecimal timestamp = this.coinbase.getTime("2018-04-08").getData().getEpoch();
        CoinbaseBuySellResponse sells = this.coinbase.getSells("2018-04-08", apiKey, this.signatureCreator2, timestamp, accountId, params.getLimit(), params.getStartId());
        return CoinbaseAdapters.adaptTrades(sells.getData(), Order.OrderType.ASK);
    }
}

