/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.crypto.Mac;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.coinbase.service.CoinbaseDigest;
import org.knowm.xchange.coinbase.v2.Coinbase;
import org.knowm.xchange.coinbase.v2.CoinbaseAuthenticated;
import org.knowm.xchange.coinbase.v2.CoinbaseV2Digest;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbaseCurrencyData;
import org.knowm.xchange.coinbase.v2.dto.marketdata.CoinbaseTimeData;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import org.knowm.xchange.utils.DigestUtils;

public class CoinbaseBaseService
extends BaseExchangeService
implements BaseService {
    protected final CoinbaseAuthenticated coinbase;
    protected final CoinbaseV2Digest signatureCreator2;

    protected CoinbaseBaseService(Exchange exchange) {
        super(exchange);
        this.coinbase = (CoinbaseAuthenticated)ExchangeRestProxyBuilder.forInterface(CoinbaseAuthenticated.class, (ExchangeSpecification)exchange.getExchangeSpecification()).build();
        this.signatureCreator2 = CoinbaseV2Digest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public List<CoinbaseCurrencyData.CoinbaseCurrency> getCoinbaseCurrencies() throws IOException {
        return this.coinbase.getCurrencies("2018-04-08").getData();
    }

    public CoinbaseTimeData.CoinbaseTime getCoinbaseTime() throws IOException {
        return this.coinbase.getTime("2018-04-08").getData();
    }

    protected String getSignature(BigDecimal timestamp, HttpMethod method, String path, String body) {
        String secretKey = this.exchange.getExchangeSpecification().getSecretKey();
        String message = timestamp + method.toString() + path + (body != null ? body : "");
        Mac mac = CoinbaseDigest.createInstance(secretKey).getMac();
        byte[] bytes = mac.doFinal(message.getBytes(StandardCharsets.UTF_8));
        return DigestUtils.bytesToHex((byte[])bytes);
    }

    protected void showCurl(HttpMethod method, String apiKey, BigDecimal timestamp, String signature, String path, String json) {
        String headers = String.format("-H 'CB-VERSION: 2017-11-26' -H 'CB-ACCESS-KEY: %s' -H 'CB-ACCESS-SIGN: %s' -H 'CB-ACCESS-TIMESTAMP: %s'", apiKey, signature, timestamp);
        if (method == HttpMethod.GET) {
            Coinbase.LOG.debug(String.format("curl %s https://api.coinbase.com%s", headers, path));
        } else if (method == HttpMethod.POST) {
            String payload = "-d '" + json + "'";
            Coinbase.LOG.debug(String.format("curl -X %s -H 'Content-Type: %s' %s %s https://api.coinbase.com%s", new Object[]{method, "application/json", headers, payload, path}));
        }
    }

    public static enum HttpMethod {
        GET,
        POST;

    }
}

