/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.service;

import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfer;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfers;
import org.knowm.xchange.coinbase.service.CoinbaseBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

class CoinbaseTradeServiceRaw
extends CoinbaseBaseService {
    protected CoinbaseTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public CoinbaseTransfer buy(BigDecimal quantity) throws IOException {
        CoinbaseTransfer buyTransfer = this.coinbase.buy(quantity.toPlainString(), false, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(buyTransfer);
    }

    public CoinbaseTransfer buyAndAgreeBTCAmountVaries(BigDecimal quantity) throws IOException {
        CoinbaseTransfer buyTransfer = this.coinbase.buy(quantity.toPlainString(), true, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(buyTransfer);
    }

    public CoinbaseTransfer sell(BigDecimal quantity) throws IOException {
        CoinbaseTransfer sellTransfer = this.coinbase.sell(quantity.toPlainString(), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return this.handleResponse(sellTransfer);
    }

    public CoinbaseTransfers getCoinbaseTransfers() throws IOException {
        return this.getCoinbaseTransfers(null, null);
    }

    public CoinbaseTransfers getCoinbaseTransfers(Integer page, Integer limit) throws IOException {
        CoinbaseTransfers transfers = this.coinbase.getTransfers(page, limit, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        return transfers;
    }
}

