/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbasePrice;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseSpotPriceHistory;
import org.knowm.xchange.coinbase.service.CoinbaseBaseService;

class CoinbaseMarketDataServiceRaw
extends CoinbaseBaseService {
    public CoinbaseMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public Map<String, BigDecimal> getCoinbaseCurrencyExchangeRates() throws IOException {
        return this.coinbase.getCurrencyExchangeRates();
    }

    public CoinbasePrice getCoinbaseBuyPrice() throws IOException {
        return this.getCoinbaseBuyPrice(null, null);
    }

    public CoinbasePrice getCoinbaseBuyPrice(BigDecimal quantity) throws IOException {
        return this.getCoinbaseBuyPrice(quantity, null);
    }

    public CoinbasePrice getCoinbaseBuyPrice(BigDecimal quantity, String currency) throws IOException {
        return this.coinbase.getBuyPrice(quantity, currency);
    }

    public CoinbasePrice getCoinbaseSellPrice() throws IOException {
        return this.getCoinbaseSellPrice(null, null);
    }

    public CoinbasePrice getCoinbaseSellPrice(BigDecimal quantity) throws IOException {
        return this.getCoinbaseSellPrice(quantity, null);
    }

    public CoinbasePrice getCoinbaseSellPrice(BigDecimal quantity, String currency) throws IOException {
        return this.coinbase.getSellPrice(quantity, currency);
    }

    public CoinbaseMoney getCoinbaseSpotRate(String currency) throws IOException {
        return this.coinbase.getSpotRate(currency);
    }

    public CoinbaseSpotPriceHistory getCoinbaseHistoricalSpotRates() throws IOException {
        return this.getCoinbaseHistoricalSpotRates(null);
    }

    public CoinbaseSpotPriceHistory getCoinbaseHistoricalSpotRates(Integer page) throws IOException {
        return CoinbaseSpotPriceHistory.fromRawString(this.coinbase.getHistoricalSpotRates(page));
    }
}

