/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.trade;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseCentsDeserializer;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseMoneyDeserializer;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransferType;
import org.knowm.xchange.utils.DateUtils;

@JsonDeserialize(using=CoinbaseTransferDeserializer.class)
public class CoinbaseTransfer
extends CoinbaseBaseResponse {
    private final String id;
    private final CoinbaseTransferType type;
    private final String fundingType;
    private final String code;
    private final Date createdAt;
    private final CoinbaseMoney coinbaseFee;
    private final CoinbaseMoney bankFee;
    private final Date payoutDate;
    private final String transactionId;
    private final CoinbaseTransferStatus status;
    private final CoinbaseMoney btcAmount;
    private final CoinbaseMoney subtotal;
    private final CoinbaseMoney total;
    private final String description;

    public CoinbaseTransfer(String id, CoinbaseTransferType type, String fundingType, String code, Date createdAt, CoinbaseMoney coinbaseFee, CoinbaseMoney bankFee, Date payoutDate, String transactionId, CoinbaseTransferStatus status, CoinbaseMoney btcAmount, CoinbaseMoney subtotal, CoinbaseMoney total, String description, boolean success, List<String> errors) {
        super(success, errors);
        this.id = id;
        this.type = type;
        this.fundingType = fundingType;
        this.code = code;
        this.createdAt = createdAt;
        this.coinbaseFee = coinbaseFee;
        this.bankFee = bankFee;
        this.payoutDate = payoutDate;
        this.transactionId = transactionId;
        this.status = status;
        this.btcAmount = btcAmount;
        this.subtotal = subtotal;
        this.total = total;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public CoinbaseTransferType getType() {
        return this.type;
    }

    public String getFundingType() {
        return this.fundingType;
    }

    public String getCode() {
        return this.code;
    }

    public CoinbaseMoney getCoinbaseFee() {
        return this.coinbaseFee;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public CoinbaseMoney getBankFee() {
        return this.bankFee;
    }

    public Date getPayoutDate() {
        return this.payoutDate;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public CoinbaseTransferStatus getStatus() {
        return this.status;
    }

    public CoinbaseMoney getBtcAmount() {
        return this.btcAmount;
    }

    public CoinbaseMoney getSubtotal() {
        return this.subtotal;
    }

    public CoinbaseMoney getTotal() {
        return this.total;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return "CoinbaseTransfer [id=" + this.id + ", type=" + (Object)((Object)this.type) + ", fundingType=" + this.fundingType + ", code=" + this.code + ", createdAt=" + this.createdAt + ", coinbaseFee=" + this.coinbaseFee + ", bankFee=" + this.bankFee + ", payoutDate=" + this.payoutDate + ", transactionId=" + this.transactionId + ", status=" + (Object)((Object)this.status) + ", btcAmount=" + this.btcAmount + ", subtotal=" + this.subtotal + ", total=" + this.total + ", description=" + this.description + "]";
    }

    public static enum CoinbaseTransferStatus {
        PENDING,
        COMPLETED,
        CANCELED,
        REVERSED;

    }

    static class CoinbaseTransferDeserializer
    extends JsonDeserializer<CoinbaseTransfer> {
        CoinbaseTransferDeserializer() {
        }

        public CoinbaseTransfer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            JsonNode successNode = node.path("success");
            boolean success = true;
            ArrayList<String> errors = new ArrayList<String>();
            if (successNode.isBoolean()) {
                success = successNode.asBoolean();
                JsonNode errorsNode = node.path("errors");
                if (errorsNode.isArray()) {
                    for (JsonNode errorNode : errorsNode) {
                        errors.add(errorNode.asText());
                    }
                }
            }
            JsonNode transferNode = node.path("transfer");
            String id = transferNode.path("id").asText();
            String fundingType = transferNode.path("_type").asText();
            CoinbaseTransferType type = CoinbaseTransferType.valueOf(transferNode.path("type").asText().toUpperCase());
            String code = transferNode.path("code").asText();
            Date createdAt = DateUtils.fromISO8601DateString((String)transferNode.path("created_at").asText());
            JsonNode feesNode = transferNode.path("fees");
            CoinbaseMoney coinbaseFee = CoinbaseCentsDeserializer.getCoinbaseMoneyFromCents(feesNode.path("coinbase"));
            CoinbaseMoney bankFee = CoinbaseCentsDeserializer.getCoinbaseMoneyFromCents(feesNode.path("bank"));
            Date payoutDate = DateUtils.fromISO8601DateString((String)transferNode.path("payout_date").asText());
            String transactionId = transferNode.path("transaction_id").asText();
            CoinbaseTransferStatus status = CoinbaseTransferStatus.valueOf(transferNode.path("status").asText().toUpperCase());
            CoinbaseMoney btcAmount = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(transferNode.path("btc"));
            CoinbaseMoney subtotal = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(transferNode.path("subtotal"));
            CoinbaseMoney total = CoinbaseMoneyDeserializer.getCoinbaseMoneyFromNode(transferNode.path("total"));
            String description = transferNode.path("description").asText();
            return new CoinbaseTransfer(id, type, fundingType, code, createdAt, coinbaseFee, bankFee, payoutDate, transactionId, status, btcAmount, subtotal, total, description, success, errors);
        }
    }
}

