/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;

public class CoinbaseCentsDeserializer
extends JsonDeserializer<CoinbaseMoney> {
    public static CoinbaseMoney getCoinbaseMoneyFromCents(JsonNode node) {
        String amount = node.path("cents").asText();
        String currency = node.path("currency_iso").asText();
        int numDecimals = currency.equalsIgnoreCase("BTC") ? 8 : 2;
        return new CoinbaseMoney(currency, new BigDecimal(amount).movePointLeft(numDecimals));
    }

    public CoinbaseMoney deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        return CoinbaseCentsDeserializer.getCoinbaseMoneyFromCents(node);
    }
}

