/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.merchant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.common.CoinbaseRepeat;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButtonStyle;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButtonType;
import org.knowm.xchange.coinbase.dto.serialization.CoinbaseCentsDeserializer;

public class CoinbaseButton
extends CoinbaseBaseResponse {
    @JsonProperty(value="button")
    private final CoinbaseButtonInfo button;

    private CoinbaseButton(@JsonProperty(value="button") CoinbaseButtonInfo button, @JsonProperty(value="success") boolean success, @JsonProperty(value="errors") List<String> errors) {
        super(success, errors);
        this.button = button;
    }

    CoinbaseButton(CoinbaseButtonInfo button) {
        super(true);
        this.button = button;
    }

    @JsonIgnore
    public CoinbaseButtonType getType() {
        return this.button.getType();
    }

    @JsonIgnore
    public String getName() {
        return this.button.getName();
    }

    @JsonIgnore
    public String getDescription() {
        return this.button.getDescription();
    }

    @JsonIgnore
    public String getId() {
        return this.button.getId();
    }

    @JsonIgnore
    public CoinbaseMoney getPrice() {
        return this.button.getPrice();
    }

    @JsonIgnore
    public String getPriceString() {
        return this.button.getPriceString();
    }

    @JsonIgnore
    public String getCurrency() {
        return this.button.getCurrency();
    }

    @JsonIgnore
    public String getCustom() {
        return this.button.getCustom();
    }

    @JsonIgnore
    public CoinbaseButtonStyle getStyle() {
        return this.button.getStyle();
    }

    @JsonIgnore
    public String getCode() {
        return this.button.getCode();
    }

    @JsonIgnore
    public String getText() {
        return this.button.getText();
    }

    @JsonIgnore
    public CoinbaseRepeat getRepeat() {
        return this.button.getRepeat();
    }

    @JsonIgnore
    public boolean isCustomSecure() {
        return this.button.isCustomSecure();
    }

    @JsonIgnore
    public String getCallbackUrl() {
        return this.button.getCallbackUrl();
    }

    @JsonIgnore
    public String getSuccessUrl() {
        return this.button.getSuccessUrl();
    }

    @JsonIgnore
    public String getCancelUrl() {
        return this.button.getCancelUrl();
    }

    @JsonIgnore
    public String getInfoUrl() {
        return this.button.getInfoUrl();
    }

    @JsonIgnore
    public boolean isAutoReDirect() {
        return this.button.isAutoReDirect();
    }

    @JsonIgnore
    public boolean isVariablePrice() {
        return this.button.isVariablePrice();
    }

    @JsonIgnore
    public boolean isChoosePrice() {
        return this.button.isChoosePrice();
    }

    @JsonIgnore
    public boolean isIncludeAddress() {
        return this.button.isIncludeAddress();
    }

    @JsonIgnore
    public boolean isIncludeEmail() {
        return this.button.isIncludeEmail();
    }

    @JsonIgnore
    public List<String> getSuggestedPrices() {
        ArrayList<String> suggestedPrices = new ArrayList<String>();
        suggestedPrices.add(this.button.price1);
        suggestedPrices.add(this.button.price2);
        suggestedPrices.add(this.button.price3);
        suggestedPrices.add(this.button.price4);
        suggestedPrices.add(this.button.price5);
        return suggestedPrices;
    }

    @JsonIgnore
    public String getPrice1() {
        return this.button.getPrice1();
    }

    @JsonIgnore
    public String getPrice2() {
        return this.button.getPrice2();
    }

    @JsonIgnore
    public String getPrice3() {
        return this.button.getPrice3();
    }

    @JsonIgnore
    public String getPrice4() {
        return this.button.getPrice4();
    }

    @JsonIgnore
    public String getPrice5() {
        return this.button.getPrice5();
    }

    @Override
    public String toString() {
        return "CoinbaseButton [button=" + this.button + "]";
    }

    static class CoinbaseButtonInfo {
        private final String name;
        private final CoinbaseMoney price;
        private final CoinbaseButtonType type;
        private final String description;
        private final String id;
        private final String custom;
        private final CoinbaseButtonStyle style;
        private final String code;
        private final String text;
        private final CoinbaseRepeat repeat;
        private final boolean customSecure;
        private final String callbackUrl;
        private final String successUrl;
        private final String cancelUrl;
        private final String infoUrl;
        private final boolean autoReDirect;
        private final boolean variablePrice;
        private final boolean choosePrice;
        private final boolean includeAddress;
        private final boolean includeEmail;
        private final String price1;
        private final String price2;
        private final String price3;
        private final String price4;
        private final String price5;

        private CoinbaseButtonInfo(@JsonProperty(value="name") String name, @JsonProperty(value="price") @JsonDeserialize(using=CoinbaseCentsDeserializer.class) CoinbaseMoney price, @JsonProperty(value="type") CoinbaseButtonType type, @JsonProperty(value="description") String description, @JsonProperty(value="id") String id, @JsonProperty(value="custom") String custom, @JsonProperty(value="style") CoinbaseButtonStyle style, @JsonProperty(value="code") String code, @JsonProperty(value="text") String text, @JsonProperty(value="repeat") CoinbaseRepeat repeat, @JsonProperty(value="custom_secure") boolean customSecure, @JsonProperty(value="callback_url") String callbackUrl, @JsonProperty(value="success_url") String successUrl, @JsonProperty(value="cancel_url") String cancelUrl, @JsonProperty(value="info_url") String infoUrl, @JsonProperty(value="auto_redirect") boolean autoDirect, @JsonProperty(value="variable_price") boolean variablePrice, @JsonProperty(value="choose_price") boolean choosePrice, @JsonProperty(value="include_address") boolean includeAddress, @JsonProperty(value="include_email") boolean includeEmail, @JsonProperty(value="price1") String price1, @JsonProperty(value="price2") String price2, @JsonProperty(value="price3") String price3, @JsonProperty(value="price4") String price4, @JsonProperty(value="price5") String price5) {
            this.name = name;
            this.price = price;
            this.type = type;
            this.description = description;
            this.id = id;
            this.custom = custom;
            this.style = style;
            this.code = code;
            this.text = text;
            this.repeat = repeat;
            this.customSecure = customSecure;
            this.callbackUrl = callbackUrl;
            this.successUrl = successUrl;
            this.cancelUrl = cancelUrl;
            this.infoUrl = infoUrl;
            this.autoReDirect = autoDirect;
            this.variablePrice = variablePrice;
            this.choosePrice = choosePrice;
            this.includeAddress = includeAddress;
            this.includeEmail = includeEmail;
            this.price1 = price1;
            this.price2 = price2;
            this.price3 = price3;
            this.price4 = price4;
            this.price5 = price5;
        }

        @JsonProperty(value="type")
        public CoinbaseButtonType getType() {
            return this.type;
        }

        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @JsonProperty(value="description")
        public String getDescription() {
            return this.description;
        }

        @JsonIgnore
        public String getId() {
            return this.id;
        }

        @JsonIgnore
        public CoinbaseMoney getPrice() {
            return this.price;
        }

        @JsonProperty(value="price_string")
        public String getPriceString() {
            return this.price.getAmount().toPlainString();
        }

        @JsonProperty(value="price_currency_iso")
        public String getCurrency() {
            return this.price.getCurrency();
        }

        @JsonProperty(value="custom")
        public String getCustom() {
            return this.custom;
        }

        @JsonProperty(value="style")
        public CoinbaseButtonStyle getStyle() {
            return this.style;
        }

        @JsonIgnore
        public String getCode() {
            return this.code;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="repeat")
        public CoinbaseRepeat getRepeat() {
            return this.repeat;
        }

        @JsonProperty(value="custom_secure")
        public boolean isCustomSecure() {
            return this.customSecure;
        }

        @JsonProperty(value="callback_url")
        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        @JsonProperty(value="success_url")
        public String getSuccessUrl() {
            return this.successUrl;
        }

        @JsonProperty(value="cancel_url")
        public String getCancelUrl() {
            return this.cancelUrl;
        }

        @JsonProperty(value="info_url")
        public String getInfoUrl() {
            return this.infoUrl;
        }

        @JsonProperty(value="auto_direct")
        public boolean isAutoReDirect() {
            return this.autoReDirect;
        }

        @JsonProperty(value="variable_price")
        public boolean isVariablePrice() {
            return this.variablePrice;
        }

        @JsonProperty(value="choose_price")
        public boolean isChoosePrice() {
            return this.choosePrice;
        }

        @JsonProperty(value="include_address")
        public boolean isIncludeAddress() {
            return this.includeAddress;
        }

        @JsonProperty(value="include_email")
        public boolean isIncludeEmail() {
            return this.includeEmail;
        }

        @JsonProperty(value="price1")
        public String getPrice1() {
            return this.price1;
        }

        @JsonProperty(value="price2")
        public String getPrice2() {
            return this.price2;
        }

        @JsonProperty(value="price3")
        public String getPrice3() {
            return this.price3;
        }

        @JsonProperty(value="price4")
        public String getPrice4() {
            return this.price4;
        }

        @JsonProperty(value="price5")
        public String getPrice5() {
            return this.price5;
        }

        public String toString() {
            return "CoinbaseButtonInfo [name=" + this.name + ", price=" + this.price + ", type=" + (Object)((Object)this.type) + ", description=" + this.description + ", id=" + this.id + ", custom=" + this.custom + ", style=" + (Object)((Object)this.style) + ", code=" + this.code + ", text=" + this.text + ", repeat=" + (Object)((Object)this.repeat) + ", customSecure=" + this.customSecure + ", callbackUrl=" + this.callbackUrl + ", successUrl=" + this.successUrl + ", cancelUrl=" + this.cancelUrl + ", infoUrl=" + this.infoUrl + ", autoDirect=" + this.autoReDirect + ", variablePrice=" + this.variablePrice + ", choosePrice=" + this.choosePrice + ", includeAddress=" + this.includeAddress + ", includeEmail=" + this.includeEmail + ", price1=" + this.price1 + ", price2=" + this.price2 + ", price3=" + this.price3 + ", price4=" + this.price4 + ", price5=" + this.price5 + "]";
        }
    }

    public static class CoinbaseButtonBuilder {
        private static final int MAX_SUGGESTED_PRICES = 5;
        private final String name;
        private final CoinbaseMoney price;
        private CoinbaseButtonType type;
        private String description;
        private String custom;
        private CoinbaseButtonStyle style;
        private String text;
        private CoinbaseRepeat repeat;
        private boolean customSecure;
        private String callbackUrl;
        private String successUrl;
        private String cancelUrl;
        private String infoUrl;
        private boolean autoDirect;
        private boolean variablePrice;
        private boolean choosePrice;
        private boolean includeAddress;
        private boolean includeEmail;
        private String price1;
        private String price2;
        private String price3;
        private String price4;
        private String price5;

        public CoinbaseButtonBuilder(String name, String currency, String priceString) {
            this(name, new CoinbaseMoney(currency, new BigDecimal(priceString)));
        }

        public CoinbaseButtonBuilder(String name, CoinbaseMoney price) {
            this.name = name;
            this.price = price;
        }

        public CoinbaseButton buildButton() {
            CoinbaseButtonInfo buttonInfo = new CoinbaseButtonInfo(this.name, this.price, this.type, this.description, null, this.custom, this.style, null, this.text, this.repeat, this.customSecure, this.callbackUrl, this.successUrl, this.cancelUrl, this.infoUrl, this.autoDirect, this.variablePrice, this.choosePrice, this.includeAddress, this.includeEmail, this.price1, this.price2, this.price3, this.price4, this.price5);
            return new CoinbaseButton(buttonInfo);
        }

        public String getName() {
            return this.name;
        }

        public CoinbaseMoney getPrice() {
            return this.price;
        }

        public String getPriceString() {
            return this.price.getAmount().toPlainString();
        }

        public String getCurrency() {
            return this.price.getCurrency();
        }

        public CoinbaseButtonType getType() {
            return this.type;
        }

        public CoinbaseButtonBuilder withType(CoinbaseButtonType type) {
            this.type = type;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public CoinbaseButtonBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public String getCustom() {
            return this.custom;
        }

        public CoinbaseButtonBuilder withCustom(String custom) {
            this.custom = custom;
            return this;
        }

        public CoinbaseButtonStyle getStyle() {
            return this.style;
        }

        public CoinbaseButtonBuilder withStyle(CoinbaseButtonStyle style) {
            this.style = style;
            return this;
        }

        public String getText() {
            return this.text;
        }

        public CoinbaseButtonBuilder withText(String text) {
            this.text = text;
            return this;
        }

        public CoinbaseRepeat getRepeat() {
            return this.repeat;
        }

        public CoinbaseButtonBuilder withRepeat(CoinbaseRepeat repeat) {
            this.repeat = repeat;
            return this;
        }

        public boolean isCustomSecure() {
            return this.customSecure;
        }

        public CoinbaseButtonBuilder withCustomSecure(boolean customSecure) {
            this.customSecure = customSecure;
            return this;
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        public CoinbaseButtonBuilder withCallbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public String getSuccessUrl() {
            return this.successUrl;
        }

        public CoinbaseButtonBuilder withSuccessUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }

        public String getCancelUrl() {
            return this.cancelUrl;
        }

        public CoinbaseButtonBuilder withCancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public String getInfoUrl() {
            return this.infoUrl;
        }

        public CoinbaseButtonBuilder withInfoUrl(String infoUrl) {
            this.infoUrl = infoUrl;
            return this;
        }

        public boolean isAutoDirect() {
            return this.autoDirect;
        }

        public CoinbaseButtonBuilder withAutoDirect(boolean autoDirect) {
            this.autoDirect = autoDirect;
            return this;
        }

        public boolean isVariablePrice() {
            return this.variablePrice;
        }

        public CoinbaseButtonBuilder withVariablePrice(boolean variablePrice) {
            this.variablePrice = variablePrice;
            return this;
        }

        public boolean isChoosePrice() {
            return this.choosePrice;
        }

        public CoinbaseButtonBuilder withChoosePrice(boolean choosePrice) {
            this.choosePrice = choosePrice;
            return this;
        }

        public boolean isIncludeAddress() {
            return this.includeAddress;
        }

        public CoinbaseButtonBuilder withIncludeAddress(boolean includeAddress) {
            this.includeAddress = includeAddress;
            return this;
        }

        public boolean isIncludeEmail() {
            return this.includeEmail;
        }

        public CoinbaseButtonBuilder withIncludeEmail(boolean includeEmail) {
            this.includeEmail = includeEmail;
            return this;
        }

        public String getPrice1() {
            return this.price1;
        }

        public String getPrice2() {
            return this.price2;
        }

        public String getPrice3() {
            return this.price3;
        }

        public String getPrice4() {
            return this.price4;
        }

        public String getPrice5() {
            return this.price5;
        }

        public CoinbaseButtonBuilder withSuggestedPrices(String ... suggestedPrices) {
            if (suggestedPrices.length > 5) {
                throw new IllegalArgumentException("Only 5 suggested prices are allowed. There was an attempt to add " + suggestedPrices.length + " prices.");
            }
            switch (suggestedPrices.length) {
                case 5: {
                    this.price5 = suggestedPrices[4];
                }
                case 4: {
                    this.price4 = suggestedPrices[3];
                }
                case 3: {
                    this.price3 = suggestedPrices[2];
                }
                case 2: {
                    this.price2 = suggestedPrices[1];
                }
                case 1: {
                    this.price1 = suggestedPrices[0];
                }
            }
            return this;
        }
    }
}

