/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase.dto.marketdata;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseHistoricalSpotPrice;
import org.knowm.xchange.utils.DateUtils;

public class CoinbaseSpotPriceHistory {
    private static final Pattern historicalRateStringPatternInReverse = Pattern.compile("(\\d{1,2}\\.\\d+),(\\d{2}:\\d{2}-\\d{2}:\\d{2}:\\d{2}T\\d{2}\\-\\d{2}-\\d{4})");
    private final List<CoinbaseHistoricalSpotPrice> spotPriceHistory;

    private CoinbaseSpotPriceHistory(List<CoinbaseHistoricalSpotPrice> spotPriceHistory) {
        this.spotPriceHistory = spotPriceHistory;
    }

    public static CoinbaseSpotPriceHistory fromRawString(String spotPriceHistoryString) {
        ArrayList<CoinbaseHistoricalSpotPrice> historicalPrices = new ArrayList<CoinbaseHistoricalSpotPrice>();
        String entireHistoryString = new StringBuilder(spotPriceHistoryString).reverse().toString();
        Matcher matcher = historicalRateStringPatternInReverse.matcher(entireHistoryString);
        while (matcher.find()) {
            String rateString = new StringBuilder(matcher.group(1)).reverse().toString();
            BigDecimal spotRate = new BigDecimal(rateString);
            String timestampString = new StringBuilder(matcher.group(2)).reverse().toString();
            Date timestamp = null;
            try {
                timestamp = DateUtils.fromISO8601DateString((String)timestampString);
            }
            catch (InvalidFormatException e) {
                e.printStackTrace();
            }
            CoinbaseHistoricalSpotPrice historicalSpotPrice = new CoinbaseHistoricalSpotPrice(timestamp, spotRate);
            historicalPrices.add(historicalSpotPrice);
        }
        Collections.sort(historicalPrices, Collections.reverseOrder());
        return new CoinbaseSpotPriceHistory(historicalPrices);
    }

    public List<CoinbaseHistoricalSpotPrice> getSpotPriceHistory() {
        return this.spotPriceHistory;
    }

    public String toString() {
        return "CoinbaseSpotPriceHistory [spotPriceHistory=" + this.spotPriceHistory + "]";
    }
}

