/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.coinbase;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.coinbase.Coinbase;
import org.knowm.xchange.coinbase.dto.CoinbaseBaseResponse;
import org.knowm.xchange.coinbase.dto.CoinbaseException;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAccountChanges;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddress;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddressCallback;
import org.knowm.xchange.coinbase.dto.account.CoinbaseAddresses;
import org.knowm.xchange.coinbase.dto.account.CoinbaseContacts;
import org.knowm.xchange.coinbase.dto.account.CoinbaseRecurringPayment;
import org.knowm.xchange.coinbase.dto.account.CoinbaseRecurringPayments;
import org.knowm.xchange.coinbase.dto.account.CoinbaseTransaction;
import org.knowm.xchange.coinbase.dto.account.CoinbaseTransactions;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUser;
import org.knowm.xchange.coinbase.dto.account.CoinbaseUsers;
import org.knowm.xchange.coinbase.dto.marketdata.CoinbaseMoney;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseButton;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseOrder;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseOrders;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseSubscription;
import org.knowm.xchange.coinbase.dto.merchant.CoinbaseSubscriptions;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfer;
import org.knowm.xchange.coinbase.dto.trade.CoinbaseTransfers;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="api/v1")
@Produces(value={"application/json"})
public interface CoinbaseAuthenticated
extends Coinbase {
    @GET
    @Path(value="users")
    public CoinbaseUsers getUsers(@HeaderParam(value="ACCESS_KEY") String var1, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var2, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var3) throws IOException, CoinbaseException;

    @PUT
    @Path(value="users/{userId}")
    @Consumes(value={"application/json"})
    public CoinbaseUser updateUser(@PathParam(value="userId") String var1, CoinbaseUser var2, @HeaderParam(value="ACCESS_KEY") String var3, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var4, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var5) throws IOException, CoinbaseException;

    @POST
    @Path(value="tokens/redeem")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseBaseResponse redeemToken(@QueryParam(value="token_id") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="account/balance")
    public CoinbaseMoney getBalance(@HeaderParam(value="ACCESS_KEY") String var1, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var2, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var3) throws IOException, CoinbaseException;

    @GET
    @Path(value="account/receive_address")
    public CoinbaseAddress getReceiveAddress(@HeaderParam(value="ACCESS_KEY") String var1, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var2, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var3) throws IOException, CoinbaseException;

    @POST
    @Path(value="account/generate_receive_address")
    @Consumes(value={"application/json"})
    public CoinbaseAddress generateReceiveAddress(CoinbaseAddressCallback var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="account_changes")
    public CoinbaseAccountChanges getAccountChanges(@QueryParam(value="page") Integer var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="addresses")
    public CoinbaseAddresses getAddresses(@QueryParam(value="page") Integer var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="query") String var3, @HeaderParam(value="ACCESS_KEY") String var4, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var5, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var6) throws IOException, CoinbaseException;

    @GET
    @Path(value="contacts")
    public CoinbaseContacts getContacts(@QueryParam(value="page") Integer var1, @QueryParam(value="num_pages") Integer var2, @QueryParam(value="query") String var3, @HeaderParam(value="ACCESS_KEY") String var4, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var5, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var6) throws IOException, CoinbaseException;

    @GET
    @Path(value="transfers")
    public CoinbaseTransfers getTransfers(@QueryParam(value="page") Integer var1, @QueryParam(value="limit") Integer var2, @HeaderParam(value="ACCESS_KEY") String var3, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var4, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="transactions")
    public CoinbaseTransactions getTransactions(@QueryParam(value="page") Integer var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="transactions/{transactionId}")
    public CoinbaseTransaction getTransactionDetails(@PathParam(value="transactionId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="transactions/request_money")
    @Consumes(value={"application/json"})
    public CoinbaseTransaction requestMoney(CoinbaseTransaction var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="transactions/send_money")
    @Consumes(value={"application/json"})
    public CoinbaseTransaction sendMoney(CoinbaseTransaction var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @PUT
    @Path(value="transactions/{transactionId}/resend_request")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseBaseResponse resendRequest(@PathParam(value="transactionId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @PUT
    @Path(value="transactions/{transactionId}/complete_request")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseTransaction completeRequest(@PathParam(value="transactionId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @DELETE
    @Path(value="transactions/{transactionId}/cancel_request")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseBaseResponse cancelRequest(@PathParam(value="transactionId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="buttons")
    @Consumes(value={"application/json"})
    public CoinbaseButton createButton(CoinbaseButton var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="orders")
    public CoinbaseOrders getOrders(@QueryParam(value="page") Integer var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="orders/{orderId}")
    public CoinbaseOrder getOrder(@PathParam(value="orderId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="buttons/{code}/create_order")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseOrder createOrder(@PathParam(value="code") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="orders")
    @Consumes(value={"application/json"})
    public CoinbaseOrder createOrder(CoinbaseButton var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="recurring_payments")
    public CoinbaseRecurringPayments getRecurringPayments(@QueryParam(value="page") Integer var1, @QueryParam(value="limit") Integer var2, @HeaderParam(value="ACCESS_KEY") String var3, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var4, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="recurring_payments/{recurringPaymentId}")
    public CoinbaseRecurringPayment getRecurringPayment(@PathParam(value="recurringPaymentId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @GET
    @Path(value="subscribers")
    public CoinbaseSubscriptions getsSubscriptions(@QueryParam(value="page") Integer var1, @QueryParam(value="limit") Integer var2, @HeaderParam(value="ACCESS_KEY") String var3, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var4, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var5) throws IOException, CoinbaseException;

    @GET
    @Path(value="subscribers/{subscriptionId}")
    public CoinbaseSubscription getsSubscription(@PathParam(value="subscriptionId") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;

    @POST
    @Path(value="buys")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseTransfer buy(@QueryParam(value="qty") String var1, @QueryParam(value="agree_btc_amount_varies") boolean var2, @HeaderParam(value="ACCESS_KEY") String var3, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var4, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var5) throws IOException, CoinbaseException;

    @POST
    @Path(value="sells")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public CoinbaseTransfer sell(@QueryParam(value="qty") String var1, @HeaderParam(value="ACCESS_KEY") String var2, @HeaderParam(value="ACCESS_SIGNATURE") ParamsDigest var3, @HeaderParam(value="ACCESS_NONCE") SynchronizedValueFactory<Long> var4) throws IOException, CoinbaseException;
}

