/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexDepth;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexSymbol;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.trade.LimitOrder;

public class BittrexMarketDataServiceRaw
extends BittrexBaseService {
    public BittrexMarketDataServiceRaw(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public List<BittrexSymbol> getBittrexSymbols() throws IOException {
        return (List)this.decorateApiCall(this.bittrexAuthenticated::getMarkets).withRetry(this.retry("getMarkets")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public BittrexMarketSummary getBittrexMarketSummary(String pair) throws IOException {
        return (BittrexMarketSummary)this.decorateApiCall(() -> this.bittrexAuthenticated.getMarketSummary(pair)).withRetry(this.retry("getMarkets")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public List<BittrexMarketSummary> getBittrexMarketSummaries() throws IOException {
        return (List)this.decorateApiCall(this.bittrexAuthenticated::getMarketSummaries).withRetry(this.retry("getMarketSummaries")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public BittrexTicker getBittrexTicker(String pair) throws IOException {
        return (BittrexTicker)this.decorateApiCall(() -> this.bittrexAuthenticated.getTicker(pair)).withRetry(this.retry("getTicker")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public List<BittrexTicker> getBittrexTickers() throws IOException {
        return (List)this.decorateApiCall(this.bittrexAuthenticated::getTickers).withRetry(this.retry("getTickers")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public SequencedOrderBook getBittrexSequencedOrderBook(String market, int depth) throws IOException {
        BittrexDepth bittrexDepth = (BittrexDepth)this.decorateApiCall(() -> this.bittrexAuthenticated.getOrderBook(market, depth)).withRetry(this.retry("getOrderBook")).withRateLimiter(this.rateLimiter("orderBooksRateLimiter")).call();
        CurrencyPair currencyPair = BittrexUtils.toCurrencyPair(market);
        List<LimitOrder> asks = BittrexAdapters.adaptOrders(bittrexDepth.getAsks(), currencyPair, Order.OrderType.ASK, depth);
        List<LimitOrder> bids = BittrexAdapters.adaptOrders(bittrexDepth.getBids(), currencyPair, Order.OrderType.BID, depth);
        OrderBook orderBook = new OrderBook(null, asks, bids);
        return new SequencedOrderBook(bittrexDepth.getSequence(), orderBook);
    }

    public List<BittrexTrade> getBittrexTrades(String pair) throws IOException {
        return (List)this.decorateApiCall(() -> this.bittrexAuthenticated.getTrades(pair)).withRetry(this.retry("getTrades")).withRateLimiter(this.rateLimiter("publicEndpointsRateLimiter")).call();
    }

    public static class SequencedOrderBook {
        private final String sequence;
        private final OrderBook orderBook;

        public SequencedOrderBook(String sequence, OrderBook orderBook) {
            this.sequence = sequence;
            this.orderBook = orderBook;
        }

        public String getSequence() {
            return this.sequence;
        }

        public OrderBook getOrderBook() {
            return this.orderBook;
        }
    }
}

