/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.ws.rs.HeaderParam;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import si.mazi.rescu.RestInvocation;

public class BittrexDigest
extends BaseParamsDigest {
    private BittrexDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA512");
    }

    public static BittrexDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new BittrexDigest(secretKeyBase64);
    }

    public String digestParams(RestInvocation restInvocation) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        String content = restInvocation.getRequestBody();
        String contentHash = DigestUtils.bytesToHex((byte[])md.digest(content.getBytes()));
        String uri = restInvocation.getInvocationUrl();
        Long timestamp = (Long)restInvocation.getParamValue(HeaderParam.class, "Api-Timestamp");
        String method = restInvocation.getHttpMethod();
        String preSign = timestamp + uri + method + contentHash;
        Mac mac = this.getMac();
        mac.update(preSign.getBytes());
        return DigestUtils.bytesToHex((byte[])mac.doFinal());
    }
}

