/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexErrorAdapter;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.account.BittrexAddress;
import org.knowm.xchange.bittrex.service.BittrexAccountServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsZero;

public class BittrexAccountService
extends BittrexAccountServiceRaw
implements AccountService {
    public BittrexAccountService(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            return new AccountInfo(new Wallet[]{BittrexAdapters.adaptWallet(this.getBittrexBalances())});
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return this.getBittrexDepositAddresses(currency.getCurrencyCode()).get(0).getCryptoAddress();
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        try {
            BittrexAddress address = this.getBittrexDepositAddresses(currency.getCurrencyCode()).get(0);
            return new AddressWithTag(address.getCryptoAddress(), address.getCryptoAddressTag());
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return TradeHistoryParamsZero.PARAMS_ZERO;
    }
}

