/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexErrorAdapter;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexMarketSummary;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTicker;
import org.knowm.xchange.bittrex.dto.marketdata.BittrexTrade;
import org.knowm.xchange.bittrex.service.BittrexMarketDataServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.service.marketdata.params.CurrencyPairsParam;
import org.knowm.xchange.service.marketdata.params.Params;

public class BittrexMarketDataService
extends BittrexMarketDataServiceRaw
implements MarketDataService {
    public BittrexMarketDataService(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            String marketSymbol = BittrexUtils.toPairString(currencyPair);
            BittrexMarketSummary bittrexMarketSummary = this.bittrexAuthenticated.getMarketSummary(marketSymbol);
            BittrexTicker bittrexTicker = this.bittrexAuthenticated.getTicker(marketSymbol);
            return BittrexAdapters.adaptTicker(bittrexMarketSummary, bittrexTicker);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public List<Ticker> getTickers(Params params) throws IOException {
        try {
            HashSet<CurrencyPair> currencyPairs = Collections.EMPTY_SET;
            if (params instanceof CurrencyPairsParam) {
                currencyPairs = new HashSet<CurrencyPair>(((CurrencyPairsParam)params).getCurrencyPairs());
            }
            List<BittrexMarketSummary> bittrexMarketSummaries = this.getBittrexMarketSummaries();
            List<BittrexTicker> bittrexTickers = this.getBittrexTickers();
            return BittrexAdapters.adaptTickers(currencyPairs, bittrexMarketSummaries, bittrexTickers);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            int depth = 500;
            if (args != null && args.length > 0 && args[0] instanceof Integer && (Integer)args[0] > 0 && (Integer)args[0] < 500) {
                depth = (Integer)args[0];
            }
            return this.getBittrexSequencedOrderBook(BittrexUtils.toPairString(currencyPair), depth).getOrderBook();
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        try {
            List<BittrexTrade> trades = this.getBittrexTrades(BittrexUtils.toPairString(currencyPair));
            return BittrexAdapters.adaptTrades(trades, currencyPair);
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }
}

