/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.dto.account.BittrexAccountVolume;
import org.knowm.xchange.bittrex.dto.account.BittrexAddress;
import org.knowm.xchange.bittrex.dto.account.BittrexBalance;
import org.knowm.xchange.bittrex.dto.account.BittrexBalances;
import org.knowm.xchange.bittrex.dto.account.BittrexComissionRatesWithMarket;
import org.knowm.xchange.bittrex.dto.account.BittrexDepositHistory;
import org.knowm.xchange.bittrex.dto.account.BittrexNewAddress;
import org.knowm.xchange.bittrex.dto.account.BittrexWithdrawalHistory;
import org.knowm.xchange.bittrex.dto.trade.BittrexOrder;
import org.knowm.xchange.bittrex.dto.withdrawal.BittrexNewWithdrawal;
import org.knowm.xchange.bittrex.dto.withdrawal.BittrexWithdrawal;
import org.knowm.xchange.bittrex.service.BittrexBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.Balance;
import si.mazi.rescu.ParamsDigest;

public class BittrexAccountServiceRaw
extends BittrexBaseService {
    public BittrexAccountServiceRaw(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public Collection<BittrexBalance> getBittrexBalances() throws IOException {
        return this.bittrexAuthenticated.getBalances(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
    }

    public SequencedBalances getBittrexSequencedBalances() throws IOException {
        BittrexBalances bittrexBalances = this.bittrexAuthenticated.getBalances(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
        Map<Currency, Balance> balances = bittrexBalances.stream().collect(Collectors.toMap(BittrexBalance::getCurrencySymbol, balance -> new Balance.Builder().available(balance.getAvailable()).total(balance.getTotal()).currency(balance.getCurrencySymbol()).timestamp(balance.getUpdatedAt()).build()));
        return new SequencedBalances(bittrexBalances.getHeaders().get("Sequence").get(0), balances);
    }

    public BittrexBalance getBittrexBalance(Currency currency) throws IOException {
        return this.bittrexAuthenticated.getBalance(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, currency.getCurrencyCode());
    }

    public List<BittrexAddress> getBittrexDepositAddresses(String currency) throws IOException {
        if (currency == null) {
            return this.bittrexAuthenticated.getAddresses(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
        }
        return Arrays.asList(this.bittrexAuthenticated.getAddress(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, currency));
    }

    public BittrexAddress generateBittrexDepositAddress(String currency) throws IOException {
        return this.bittrexAuthenticated.generateAddress(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, new BittrexNewAddress(new Currency(currency)));
    }

    public BittrexAccountVolume getBittrexAccountVolume() throws IOException {
        return this.bittrexAuthenticated.getAccountVolume(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
    }

    public List<BittrexComissionRatesWithMarket> getTradingFees() throws IOException {
        return this.bittrexAuthenticated.getTradingFees(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator);
    }

    public BittrexOrder getBittrexOrder(String orderId) throws IOException {
        return this.bittrexAuthenticated.getOrder(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, orderId);
    }

    public List<BittrexDepositHistory> getBittrexDepositsClosed(String currencySymbol, String nextPageToken, String previousPageToken, Integer pageSize) throws IOException {
        return this.bittrexAuthenticated.getDepositsClosed(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, currencySymbol, nextPageToken, previousPageToken, pageSize);
    }

    public List<BittrexWithdrawalHistory> getBittrexWithdrawalsClosed(String currencySymbol, String nextPageToken, String previousPageToken, Integer pageSize) throws IOException {
        return this.bittrexAuthenticated.getWithdrawalsClosed(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, currencySymbol, nextPageToken, previousPageToken, pageSize);
    }

    public BittrexWithdrawal createNewWithdrawal(Currency currency, BigDecimal amount, String address) throws IOException {
        BittrexNewWithdrawal newWithdrawal = new BittrexNewWithdrawal();
        newWithdrawal.setCurrencySymbol(currency.getCurrencyCode());
        newWithdrawal.setQuantity(amount);
        newWithdrawal.setCryptoAddress(address);
        return this.bittrexAuthenticated.createNewWithdrawal(this.apiKey, System.currentTimeMillis(), this.contentCreator, (ParamsDigest)this.signatureCreator, newWithdrawal);
    }

    public static class SequencedBalances {
        private final String sequence;
        private final Map<Currency, Balance> balances;

        public SequencedBalances(String sequence, Map<Currency, Balance> balances) {
            this.sequence = sequence;
            this.balances = balances;
        }

        public String getSequence() {
            return this.sequence;
        }

        public Map<Currency, Balance> getBalances() {
            return this.balances;
        }
    }
}

