/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.bittrex.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.bittrex.BittrexAdapters;
import org.knowm.xchange.bittrex.BittrexAuthenticated;
import org.knowm.xchange.bittrex.BittrexErrorAdapter;
import org.knowm.xchange.bittrex.BittrexExchange;
import org.knowm.xchange.bittrex.BittrexUtils;
import org.knowm.xchange.bittrex.dto.BittrexException;
import org.knowm.xchange.bittrex.dto.account.BittrexAddress;
import org.knowm.xchange.bittrex.dto.account.BittrexComissionRatesWithMarket;
import org.knowm.xchange.bittrex.service.BittrexAccountServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsZero;

public class BittrexAccountService
extends BittrexAccountServiceRaw
implements AccountService {
    public BittrexAccountService(BittrexExchange exchange, BittrexAuthenticated bittrex, ResilienceRegistries resilienceRegistries) {
        super(exchange, bittrex, resilienceRegistries);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            return new AccountInfo(new Wallet[]{BittrexAdapters.adaptWallet(this.getBittrexBalances())});
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return this.getBittrexDepositAddresses(currency.getCurrencyCode()).get(0).getCryptoAddress();
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        try {
            BittrexAddress address = this.getBittrexDepositAddresses(currency.getCurrencyCode()).get(0);
            return new AddressWithTag(address.getCryptoAddress(), address.getCryptoAddressTag());
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return TradeHistoryParamsZero.PARAMS_ZERO;
    }

    public Map<Instrument, Fee> getDynamicTradingFeesByInstrument() throws IOException {
        Map<CurrencyPair, Fee> dynamicTradingFees = this.getDynamicTradingFees();
        return dynamicTradingFees.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        try {
            HashMap<CurrencyPair, Fee> result = new HashMap<CurrencyPair, Fee>();
            List<BittrexComissionRatesWithMarket> tradingFees = this.getTradingFees();
            for (BittrexComissionRatesWithMarket tradingFee : tradingFees) {
                result.put(BittrexUtils.toCurrencyPair(tradingFee.getMarketSymbol()), new Fee(BigDecimal.valueOf(tradingFee.getMakerRate()), BigDecimal.valueOf(tradingFee.getTakerRate())));
            }
            return result;
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return this.createNewWithdrawal(currency, amount, address).getId();
        }
        catch (BittrexException e) {
            throw BittrexErrorAdapter.adapt(e);
        }
    }
}

